/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.repository.Repository;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;

public class AuditUtils {
    private static final ObjectMapper objectMapperInstance = new ObjectMapper();

    public static String toProjectAndRepositoryString(@Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        return repository.getProject().getKey() + "/" + repository.getSlug();
    }

    public static String toJSONString(@Nullable Map<String, Object> value) throws IOException {
        return AuditUtils.toJsonInternal(value);
    }

    public static String toJson(@Nullable Object value) {
        try {
            return AuditUtils.toJsonInternal(value);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to convert object %s to JSON", value), e);
        }
    }

    private static String toJsonInternal(Object value) throws IOException {
        return objectMapperInstance.writeValueAsString(value);
    }
}

