/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class UrlUtils {
    private static final Pattern REDUNDANT_SLASHES = Pattern.compile("//+");

    public static String encodeURL(String fragment) {
        try {
            return URLEncoder.encode(fragment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URI uncheckedCreateURI(@Nullable String uri) {
        if (uri != null) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(uri + " is not a valid URI.");
            }
        }
        return null;
    }

    public static String concatenate(String base, String ... paths) {
        return StringUtils.stripEnd((String)base, (String)"/") + UrlUtils.removeRedundantSlashes("/" + StringUtils.join((Object[])paths, (String)"/"));
    }

    public static URI concatenate(URI base, String ... paths) throws URISyntaxException {
        return new URI(UrlUtils.concatenate(base.toASCIIString(), paths));
    }

    public static URI uncheckedConcatenate(URI base, URI ... paths) {
        try {
            String[] pathStrings = (String[])Iterables.toArray((Iterable)Lists.transform((List)Lists.newArrayList((Object[])paths), (Function)new Function<URI, String>(){

                public String apply(URI from) {
                    return from.toASCIIString();
                }
            }), String.class);
            return UrlUtils.concatenate(base, pathStrings);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to concatenate URIs", e);
        }
    }

    public static URI uncheckedConcatenateAndToUri(String base, String ... paths) {
        return UrlUtils.uncheckedCreateURI(UrlUtils.concatenate(base, paths));
    }

    public static URI uncheckedConcatenate(URI base, String ... paths) {
        try {
            return UrlUtils.concatenate(base, paths);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Failed to concatenate %s to form URI (%s)", base, e.getReason()), e);
        }
    }

    public static String removeRedundantSlashes(String path) {
        return path == null ? null : REDUNDANT_SLASHES.matcher(path).replaceAll("/");
    }

    public static URI copyOf(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI(uri.toASCIIString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to copy URI: " + uri.toASCIIString());
        }
    }

    public static URI trimTrailingSlashesFromPath(URI uri) {
        try {
            String urlPath = uri.getPath();
            if (urlPath.endsWith("/")) {
                while (urlPath.endsWith("/")) {
                    urlPath = urlPath.substring(0, urlPath.length() - 1);
                }
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), urlPath, uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Trimming slashes from path of " + uri + " resulted in invalid URI", e);
        }
    }
}

