/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesUtils.class);

    public static Properties loadFromString(String str) {
        Properties p = new Properties();
        return PropertiesUtils.loadFromString(p, str);
    }

    public static Properties loadFromString(Properties p, String str) {
        try {
            p.load(new ByteArrayInputStream(str.getBytes()));
        }
        catch (IOException e) {
            LOG.warn("Problem parsing Properties from string", (Throwable)e);
        }
        return p;
    }

    public static String saveToString(Properties props) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            props.store(out, null);
        }
        catch (IOException e) {
            LOG.warn("Problem saving Properties as string", (Throwable)e);
        }
        return new String(out.toByteArray());
    }

    public static String saveToStringSansComments(Properties props) {
        return PropertiesUtils.saveToString(props).replaceAll("^#.*\n", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadFromFile(File file) throws IOException {
        Properties properties = new Properties();
        if (file.exists()) {
            FileInputStream is = FileUtils.openInputStream((File)file);
            try {
                properties.load(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(Properties properties, File file) throws IOException {
        FileOutputStream os = FileUtils.openOutputStream((File)file);
        try {
            properties.store(os, null);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    public static String getProperty(File file, String key) throws IOException {
        Properties props = PropertiesUtils.loadFromFile(file);
        return props.getProperty(key);
    }

    public static void setProperty(File file, String key, String value) throws IOException {
        Properties props = PropertiesUtils.loadFromFile(file);
        props.setProperty(key, value);
        PropertiesUtils.writeToFile(props, file);
    }
}

