/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.stash.scm.BaseWeightedModuleDescriptor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleDescriptorUtils {
    private static final Logger log = LoggerFactory.getLogger(ModuleDescriptorUtils.class);
    private static final Function<? extends ModuleDescriptor, ?> TO_MODULE = new Function<ModuleDescriptor, Object>(){

        public Object apply(ModuleDescriptor input) {
            try {
                return input.getModule();
            }
            catch (Exception e) {
                log.info("Could not instantiate module {}", (Object)input.getCompleteKey());
                log.debug("Error instantiating module", (Throwable)e);
                return null;
            }
        }
    };

    private ModuleDescriptorUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static <T, M extends ModuleDescriptor<T>> Function<M, T> toModule() {
        return TO_MODULE;
    }

    public static <T, M extends ModuleDescriptor<T>> Iterable<T> toModules(Iterable<M> descriptors) {
        return Iterables.filter((Iterable)Iterables.transform(descriptors, ModuleDescriptorUtils.toModule()), (Predicate)Predicates.notNull());
    }

    public static <T, M extends BaseWeightedModuleDescriptor<T>> Iterable<T> toSortedModules(Iterable<M> descriptors) {
        ArrayList sorted = Lists.newArrayList(descriptors);
        Collections.sort(sorted);
        return ModuleDescriptorUtils.toModules(sorted);
    }
}

