/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.auth.HttpAuthenticationSuccessContext;
import com.atlassian.stash.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.stash.exception.DataStoreException;
import com.atlassian.stash.internal.user.InternalRecentlyAccessedRepositoriesService;
import com.atlassian.stash.internal.user.RecentlyAccessedRepositoriesServiceImpl;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecentlyAccessedRepositoriesAuthenticationSuccessHandler
implements HttpAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(RecentlyAccessedRepositoriesServiceImpl.class);
    private final InternalRecentlyAccessedRepositoriesService recentlyAccessedRepositoriesService;

    public RecentlyAccessedRepositoriesAuthenticationSuccessHandler(InternalRecentlyAccessedRepositoriesService recentlyAccessedRepositoriesService) {
        this.recentlyAccessedRepositoriesService = recentlyAccessedRepositoriesService;
    }

    public boolean onAuthenticationSuccess(@Nonnull HttpAuthenticationSuccessContext context) throws ServletException, IOException {
        if ("basic".equals(context.getMethod())) {
            return false;
        }
        try {
            this.recentlyAccessedRepositoriesService.trimForUser(context.getUser());
        }
        catch (DataStoreException e) {
            log.debug("RecentlyAccessedRepositoriesAuthenticationSuccessHandler: Aborting due to exception", (Throwable)e);
        }
        return false;
    }
}

