/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.CompositePermissionGraph;
import com.atlassian.stash.internal.user.DefaultPermissionGraph;
import com.atlassian.stash.internal.user.PermissionGraph;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.EscalatedSecurityContext;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Operation;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

class DefaultEscalatedSecurityContext
implements EscalatedSecurityContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultEscalatedSecurityContext.class);
    private final DefaultPermissionGraph elevatedPermissions;
    private final String reason;
    private final StashUser user;

    private DefaultEscalatedSecurityContext(String reason, StashUser user, DefaultPermissionGraph permissions) {
        this.elevatedPermissions = permissions;
        this.reason = reason;
        this.user = user;
    }

    DefaultEscalatedSecurityContext(String reason, StashUser user) {
        this(reason, user, new DefaultPermissionGraph.Builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T call(@Nonnull Operation<T, E> operation) throws E {
        Preconditions.checkNotNull(operation, (Object)"operation cannot be null");
        Authentication authToken = SecurityContextHolder.getContext().getAuthentication();
        DefaultPermissionGraph runWithPermissions = this.elevatedPermissions;
        if (authToken instanceof StashUserAuthenticationToken) {
            StashUserAuthenticationToken stashToken = (StashUserAuthenticationToken)authToken;
            runWithPermissions = CompositePermissionGraph.maybeCompose(runWithPermissions, stashToken.getElevatedPermissions());
        }
        StashUserAuthenticationToken runAsToken = new StashUserAuthenticationToken.Builder().user(this.user).elevatedPermissions((PermissionGraph)runWithPermissions).build();
        SecurityContextHolder.getContext().setAuthentication((Authentication)runAsToken);
        try {
            log.trace("doWithPermission: running as user {} with permissions {}, reason: {}", new Object[]{runAsToken.getName(), runWithPermissions, this.reason});
            Object object = operation.perform();
            return (T)object;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(authToken);
        }
    }

    @Nonnull
    public EscalatedSecurityContext withPermission(@Nonnull Permission permission) {
        DefaultPermissionGraph.Builder builder = new DefaultPermissionGraph.Builder().addAll(this.elevatedPermissions).add((Permission)Preconditions.checkNotNull((Object)permission, (Object)"permission"), null);
        return new DefaultEscalatedSecurityContext(this.reason, this.user, builder.build());
    }

    @Nonnull
    public EscalatedSecurityContext withPermission(@Nonnull Object resource, @Nonnull Permission permission) {
        Integer resourceId;
        if (Preconditions.checkNotNull((Object)resource, (Object)"resource") instanceof Repository) {
            resourceId = ((Repository)resource).getId();
            Preconditions.checkArgument((boolean)permission.isResource(Repository.class), (Object)"Repository permission required");
        } else if (resource instanceof Project) {
            resourceId = ((Project)resource).getId();
            Preconditions.checkArgument((boolean)permission.isResource(Project.class), (Object)"Project permission required");
        } else {
            throw new IllegalArgumentException("Only repository and project resources are supported. Got " + resource.getClass().getCanonicalName());
        }
        return new DefaultEscalatedSecurityContext(this.reason, this.user, new DefaultPermissionGraph.Builder().addAll(this.elevatedPermissions).add(permission, resourceId).build());
    }

    @Nonnull
    public EscalatedSecurityContext withPermissions(@Nonnull Set<Permission> permissions) {
        DefaultPermissionGraph.Builder builder = new DefaultPermissionGraph.Builder().addAll(this.elevatedPermissions);
        int index = 0;
        for (Permission permission : permissions) {
            builder.add((Permission)Preconditions.checkNotNull((Object)permission, (String)"permissions[%s]", (Object[])new Object[]{index++}), null);
        }
        return new DefaultEscalatedSecurityContext(this.reason, this.user, builder.build());
    }
}

