/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task.property;

import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.PullRequestCommentAnchorDao;
import com.atlassian.stash.internal.task.InternalTask;
import com.atlassian.stash.internal.task.InternalTaskContextVisitor;
import com.atlassian.stash.internal.task.property.TaskPropertyContext;
import com.atlassian.stash.internal.task.property.TaskPropertyProvider;
import com.atlassian.stash.task.TaskAnchor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ClassUtils;

public class DiffAnchorTaskPropertyProvider
implements TaskPropertyProvider {
    static final String ATTRIBUTE_KEY = "diffAnchorPath";
    private final PullRequestCommentAnchorDao anchorDao;

    public DiffAnchorTaskPropertyProvider(PullRequestCommentAnchorDao anchorDao) {
        this.anchorDao = anchorDao;
    }

    @Override
    public void provideProperties(final @Nonnull TaskPropertyContext context) {
        context.accept(new InternalTaskContextVisitor<Object>(){

            public Void visit(@Nonnull InternalPullRequest pullRequest) {
                Map commentIdsToTasks = DiffAnchorTaskPropertyProvider.this.indexByCommentIds(context);
                Collection commentAnchors = DiffAnchorTaskPropertyProvider.this.anchorDao.findByCommentIds(commentIdsToTasks.keySet());
                for (InternalPullRequestDiffCommentAnchor anchor : commentAnchors) {
                    InternalComment comment = anchor.getComment();
                    Collection tasks = (Collection)commentIdsToTasks.get(comment.getId());
                    if (tasks == null) continue;
                    for (InternalTask task : tasks) {
                        context.setProperty(task, DiffAnchorTaskPropertyProvider.ATTRIBUTE_KEY, anchor.getPath());
                    }
                }
                return null;
            }
        });
    }

    private Map<Long, Collection<InternalTask>> indexByCommentIds(Iterable<InternalTask> tasks) {
        HashMap<Long, Collection<InternalTask>> commentIdsToTasks = new HashMap<Long, Collection<InternalTask>>();
        for (InternalTask task : tasks) {
            TaskAnchor anchor = task.getAnchor();
            if (!(anchor instanceof InternalComment)) {
                throw new UnsupportedOperationException("Unsupported anchor type for task " + task.getId() + ": " + ClassUtils.getShortCanonicalName((Object)anchor, (String)"null"));
            }
            InternalComment comment = ((InternalComment)anchor).getRoot();
            Long commentId = comment.getId();
            ArrayList<InternalTask> tasksForAnchor = (ArrayList<InternalTask>)commentIdsToTasks.get(commentId);
            if (tasksForAnchor == null) {
                tasksForAnchor = new ArrayList<InternalTask>(1);
                commentIdsToTasks.put(commentId, tasksForAnchor);
            }
            tasksForAnchor.add(task);
        }
        return commentIdsToTasks;
    }
}

