/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task;

import com.atlassian.stash.internal.task.InternalTask;
import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.internal.task.InternalTaskOperations;
import com.atlassian.stash.internal.task.TaskPermissionsHelper;
import com.atlassian.stash.internal.task.TaskPostProcessor;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.task.TaskOperations;
import com.atlassian.stash.task.TaskState;
import javax.annotation.Nonnull;

public class OperationTaskPostProcessor
implements TaskPostProcessor {
    private final TaskPermissionsHelper taskPermissionsHelper;

    public OperationTaskPostProcessor(TaskPermissionsHelper taskPermissionsHelper) {
        this.taskPermissionsHelper = taskPermissionsHelper;
    }

    @Override
    @Nonnull
    public InternalTask process(InternalTask task) {
        if (task.getPermittedOperations() == null) {
            InternalTaskContext context = task.getContext();
            Repository repository = context.getScopeRepository();
            task.setPermittedOperations(this.getPermittedOperations(context, task, this.taskPermissionsHelper.isRepoAdmin(repository)));
        }
        return task;
    }

    @Override
    @Nonnull
    public Iterable<InternalTask> processAll(InternalTaskContext context, Iterable<InternalTask> tasks) {
        Repository repository = context.getScopeRepository();
        boolean isRepoAdmin = this.taskPermissionsHelper.isRepoAdmin(repository);
        for (InternalTask task : tasks) {
            if (task.getPermittedOperations() != null) continue;
            task.setPermittedOperations(this.getPermittedOperations(context, task, isRepoAdmin));
        }
        return tasks;
    }

    private TaskOperations getPermittedOperations(InternalTaskContext context, InternalTask task, boolean isRepoAdmin) {
        InternalTaskOperations permittedOperations = task.getState().equals((Object)TaskState.RESOLVED) ? InternalTaskOperations.TRANSITION : (isRepoAdmin || this.taskPermissionsHelper.hasFullPermission(context, task) ? InternalTaskOperations.ALL : InternalTaskOperations.TRANSITION);
        return permittedOperations;
    }
}

