/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.google.common.base.Function;
import java.io.Serializable;

public class PullRequestRescopeTask
implements Serializable {
    public static final Function<PullRequestRescopeTask, String> TO_BUCKET_ID = new Function<PullRequestRescopeTask, String>(){

        public String apply(PullRequestRescopeTask task) {
            return Integer.toString(task.getRepositoryId());
        }
    };
    public static final Function<PullRequestRescopeTask, Long> TO_REQUEST_ID = new Function<PullRequestRescopeTask, Long>(){

        public Long apply(PullRequestRescopeTask task) {
            return task.getRescopeRequestId();
        }
    };
    private static final long serialVersionUID = 2L;
    private final int attempt;
    private final int repositoryId;
    private final long rescopeRequestId;

    public PullRequestRescopeTask(long rescopeRequestId, int repositoryId, int attempt) {
        this.attempt = attempt;
        this.repositoryId = repositoryId;
        this.rescopeRequestId = rescopeRequestId;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public long getRescopeRequestId() {
        return this.rescopeRequestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PullRequestRescopeTask that = (PullRequestRescopeTask)o;
        return this.rescopeRequestId == that.rescopeRequestId;
    }

    public int hashCode() {
        return (int)(this.rescopeRequestId ^ this.rescopeRequestId >>> 32);
    }
}

