/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.comment.AbstractAddCommentRequest;
import com.atlassian.stash.comment.AddDiffCommentRequest;
import com.atlassian.stash.comment.AddFileCommentRequest;
import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.event.pull.PullRequestCommentActivityEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.comment.AbstractCommentHelper;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.DiffCommentAnchorSearchCriteria;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestCommentAnchorDao;
import com.atlassian.stash.internal.pull.PullRequestStateGuard;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import com.atlassian.stash.internal.pull.comment.InternalPullRequestCommentHelper;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.atlassian.stash.internal.task.InternalTaskService;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.pull.IllegalPullRequestStateException;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestCommentActivity;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.base.Function;
import java.util.List;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

public class DefaultPullRequestCommentHelper
extends AbstractCommentHelper<InternalPullRequest, InternalPullRequestDiffCommentAnchor>
implements InternalPullRequestCommentHelper {
    private final PullRequestActivityDao activityDao;
    private final ScmService scmService;
    private final TransactionSynchronizer synchronizer;
    private final PullRequestStateGuard commentStateGuard;
    @Autowired
    private CommentUpdateProcessor updateProcessor;

    public DefaultPullRequestCommentHelper(PullRequestActivityDao activityDao, PullRequestCommentAnchorDao anchorDao, StashAuthenticationContext authenticationContext, CommentDao commentDao, EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, CommentPostProcessor postProcessor, ScmService scmService, TransactionSynchronizer synchronizer, InternalTaskService taskService, Validator validator, PullRequestStateGuard commentStateGuard) {
        super(anchorDao, authenticationContext, commentDao, eventPublisher, i18nService, permissionService, postProcessor, taskService, validator);
        this.activityDao = activityDao;
        this.scmService = scmService;
        this.synchronizer = synchronizer;
        this.commentStateGuard = commentStateGuard;
    }

    @Nonnull
    public List<InternalPullRequestDiffCommentAnchor> findDiffAnchors(@Nonnull InternalPullRequest pullRequest) {
        return this.findDiffAnchors(pullRequest, null);
    }

    @Nonnull
    public List<InternalPullRequestDiffCommentAnchor> findDiffAnchors(@Nonnull InternalPullRequest pullRequest, String path) {
        return this.search(pullRequest, new DiffCommentAnchorSearchCriteria().setPath(path));
    }

    public void maybeUpdateComments(final @Nonnull InternalPullRequest pullRequest) {
        this.commentStateGuard.processIfUpdated(pullRequest, (UncheckedOperation)new UncheckedOperation<Void>(){

            public Void perform() {
                DefaultPullRequestCommentHelper.this.updateProcessor.maybeProcess(pullRequest);
                return null;
            }
        });
    }

    @Transactional
    public void updateAnchors(@Nonnull List<InternalPullRequestDiffCommentAnchor> anchors) {
        for (InternalPullRequestDiffCommentAnchor anchor : anchors) {
            this.anchorDao.update((Object)anchor);
        }
    }

    public void updateComments(final @Nonnull InternalPullRequest pullRequest, final @Nonnull String previousFromHash, final @Nonnull String previousToHash) {
        this.synchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                DefaultPullRequestCommentHelper.this.commentStateGuard.updated(pullRequest);
                DefaultPullRequestCommentHelper.this.updateProcessor.process(pullRequest, previousFromHash, previousToHash);
            }
        });
    }

    @Override
    protected void addActivity(@Nonnull InternalPullRequest pullRequest, @Nonnull InternalComment comment, InternalPullRequestDiffCommentAnchor anchor, @Nonnull CommentAction action, @Nonnull InternalStashUser user) {
        InternalPullRequestCommentActivity activity = ((InternalPullRequestCommentActivity.Builder)((InternalPullRequestCommentActivity.Builder)new InternalPullRequestCommentActivity.Builder(pullRequest).comment(comment).commentAction(action).commentAnchor(anchor).createdDate(comment.getUpdatedDate())).user(user)).build();
        this.activityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestCommentActivityEvent((Object)this, (PullRequestCommentActivity)activity));
    }

    @Override
    protected void deleteActivities(@Nonnull InternalPullRequest entity, @Nonnull InternalComment comment) {
        this.activityDao.deleteByComment(comment.getId().longValue());
    }

    @Override
    protected Function<InternalComment, InternalPullRequestDiffCommentAnchor> diffAnchor(@Nonnull InternalPullRequest pullRequest, @Nonnull AddDiffCommentRequest request) {
        return new PullRequestDiffCommentAnchorFunction(pullRequest, (AbstractAddCommentRequest)request);
    }

    @Override
    protected Function<InternalComment, InternalPullRequestDiffCommentAnchor> fileAnchor(@Nonnull InternalPullRequest pullRequest, @Nonnull AddFileCommentRequest request) {
        return new PullRequestDiffCommentAnchorFunction(pullRequest, (AbstractAddCommentRequest)request);
    }

    @Nonnull
    private PullRequestEffectiveDiff getEffectiveDiff(InternalPullRequest pullRequest) {
        PullRequestEffectiveDiff diff = (PullRequestEffectiveDiff)this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).effectiveDiff().call();
        if (diff == null) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.noeffectivediff", new Object[]{pullRequest.getId()}));
        }
        return diff;
    }

    private class PullRequestDiffCommentAnchorFunction
    implements Function<InternalComment, InternalPullRequestDiffCommentAnchor> {
        private final InternalPullRequest pullRequest;
        private final AbstractAddCommentRequest request;

        public PullRequestDiffCommentAnchorFunction(InternalPullRequest pullRequest, AbstractAddCommentRequest request) {
            this.pullRequest = pullRequest;
            this.request = request;
        }

        public InternalPullRequestDiffCommentAnchor apply(InternalComment comment) {
            PullRequestEffectiveDiff effectiveDiff = DefaultPullRequestCommentHelper.this.getEffectiveDiff(this.pullRequest);
            return ((InternalPullRequestDiffCommentAnchor.Builder)((InternalPullRequestDiffCommentAnchor.Builder)((InternalPullRequestDiffCommentAnchor.Builder)((InternalPullRequestDiffCommentAnchor.Builder)new InternalPullRequestDiffCommentAnchor.Builder(this.pullRequest).apply(this.request)).comment(comment)).fromHash(effectiveDiff.getSinceId())).toHash(effectiveDiff.getUntilId())).build();
        }
    }
}

