/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.content.AbstractChangesetCallback;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetSummary;
import com.atlassian.stash.content.InternalChangeset;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingChangesetQueueCallback
extends AbstractChangesetCallback {
    private static final Logger log = LoggerFactory.getLogger(BlockingChangesetQueueCallback.class);
    private static final Changeset FINISHED = new InternalChangeset.Builder((Repository)null).id("finished").displayId("finished").build();
    private final BlockingQueue<Changeset> queue;
    private volatile boolean finished;

    public BlockingChangesetQueueCallback(int queueSize) {
        Preconditions.checkArgument((queueSize > 0 ? 1 : 0) != 0);
        this.queue = new LinkedBlockingQueue<Changeset>(queueSize);
    }

    public void clear() {
        this.queue.clear();
        this.finished = false;
    }

    public boolean onChangeset(@Nonnull Changeset changeset) {
        try {
            this.queue.put(changeset);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Process was interrupted while waiting for space on the callback queue to become available", (Throwable)e);
            return false;
        }
        return true;
    }

    public void onEnd(@Nonnull ChangesetSummary summary) throws IOException {
        try {
            if (!Thread.currentThread().isInterrupted()) {
                this.queue.offer(FINISHED, 0L, TimeUnit.MILLISECONDS);
            }
            this.finished = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Indexing was interrupted", (Throwable)e);
        }
    }

    public Changeset poll(long timeout, TimeUnit unit) throws InterruptedException {
        Changeset result = this.queue.poll(this.finished ? 0L : timeout, unit);
        return result == FINISHED ? null : result;
    }
}

