/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n.cache;

import com.atlassian.stash.internal.i18n.cache.CacheUtils;
import com.atlassian.stash.internal.i18n.cache.MessageKey;
import com.atlassian.stash.internal.i18n.cache.MessageLocaleMap;
import com.atlassian.stash.internal.i18n.cache.MessageMap;
import com.atlassian.stash.internal.i18n.cache.UnresolvedLocales;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MessageMapIndex<K, V> {
    private final Map<K, LocaleMessages<V>> index;
    private final MessageMap<V> messages;
    private final Set<Locale> unresolvedLocales;

    MessageMapIndex() {
        this((Map<K, LocaleMessages<V>>)ImmutableMap.of(), MessageMap.empty());
    }

    MessageMapIndex(Map<K, LocaleMessages<V>> index, MessageMap<V> messages) {
        this.index = index;
        this.messages = messages;
        this.unresolvedLocales = MessageMapIndex.getLocales(index);
    }

    @Nonnull
    public MessageMapIndex<K, V> add(@Nonnull K key, @Nonnull UnresolvedLocales<V> value) {
        if (value.map.isEmpty()) {
            return this;
        }
        HashMap newIndex = Maps.newHashMap(this.index);
        newIndex.put(key, new LocaleMessages<V>((ImmutableSet<MessageKey>)ImmutableSet.of(), value));
        return new MessageMapIndex<K, V>(ImmutableMap.copyOf((Map)newIndex), this.messages);
    }

    public boolean containsUnresolved(Iterable<Locale> locales) {
        return Iterables.any(locales, (Predicate)Predicates.in(this.unresolvedLocales));
    }

    @Nonnull
    public MessageLocaleMap<V> getMessages(Iterable<Locale> locales) {
        return new MessageLocaleMap<V>(this.messages, locales);
    }

    @Nonnull
    public MessageMapIndex<K, V> loadAll(Iterable<Locale> locales) {
        MessageMapIndex<K, V> index = this;
        for (Locale locale : locales) {
            index = index.load(locale);
        }
        return index;
    }

    @Nonnull
    public MessageMapIndex<K, V> remove(@Nonnull K key) {
        LocaleMessages<V> keys = this.index.get(key);
        if (keys == null) {
            return this;
        }
        return new MessageMapIndex<K, V>(CacheUtils.filterKey(this.index, key), this.messages.remove((Collection<MessageKey>)((LocaleMessages)keys).keys));
    }

    @Nonnull
    MessageLocaleMap<V> loadAndGetMessages(Iterable<Locale> locales) {
        return this.loadAll(locales).getMessages(locales);
    }

    @Nonnull
    private MessageMapIndex<K, V> load(@Nonnull Locale locale) {
        if (!this.unresolvedLocales.contains(locale)) {
            return this;
        }
        HashMap newIndex = Maps.newHashMap(this.index);
        MessageMap.Builder<V> newMessages = this.messages.builder();
        for (Map.Entry entry : newIndex.entrySet()) {
            Supplier messageSupplier = ((LocaleMessages)((LocaleMessages)entry.getValue())).locales.map.get(locale);
            if (messageSupplier == null) continue;
            MessageMap messages = (MessageMap)messageSupplier.get();
            newMessages.putAll(messages);
            ImmutableSet keys = !messages.keySet().isEmpty() ? ImmutableSet.builder().addAll((Iterable)((LocaleMessages)entry.getValue()).keys).addAll(messages.keySet()).build() : ((LocaleMessages)entry.getValue()).keys;
            entry.setValue(new LocaleMessages((ImmutableSet<MessageKey>)keys, new UnresolvedLocales(CacheUtils.filterKey(((LocaleMessages)((LocaleMessages)entry.getValue())).locales.map, locale))));
        }
        return new MessageMapIndex<K, V>(ImmutableMap.copyOf((Map)newIndex), newMessages.build());
    }

    private static <K, V> ImmutableSet<Locale> getLocales(Map<K, LocaleMessages<V>> index) {
        ImmutableSet.Builder newLocales = ImmutableSet.builder();
        for (LocaleMessages<V> value : index.values()) {
            newLocales.addAll(((LocaleMessages)value).locales.map.keySet());
        }
        return newLocales.build();
    }

    private static class LocaleMessages<V> {
        private ImmutableSet<MessageKey> keys;
        private UnresolvedLocales<V> locales;

        public LocaleMessages(ImmutableSet<MessageKey> keys, UnresolvedLocales<V> locales) {
            this.keys = keys;
            this.locales = locales;
        }
    }
}

