/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;

public class SocketTransferOutput
implements Flushable,
Closeable {
    static final int SOCKET_OUTPUT_MAX = 65535;
    private final DataOutputStream out;

    public SocketTransferOutput(OutputStream out) {
        this.out = new DataOutputStream(out);
    }

    private void writeAsciiChar(char c) throws IOException {
        Preconditions.checkArgument((c >= '\u0001' && c <= '\u007f' ? 1 : 0) != 0, (Object)"Only ASCII characters are supported");
        this.out.write((byte)c);
    }

    public void writeStdOut(String chunk) throws IOException {
        this.writeInChunks('O', chunk);
    }

    public void writeStdErr(String chunk) throws IOException {
        this.writeInChunks('E', chunk);
    }

    public void writeExitCode(int exitCode) throws IOException {
        this.writeAsciiChar('X');
        this.writeUnsignedShort(exitCode);
    }

    private void writeInChunks(char channel, String data) throws IOException {
        for (int i = 0; i < data.length(); i += 65535) {
            this.writeAsciiChar(channel);
            this.out.writeUTF(StringUtils.substring((String)data, (int)i, (int)(i + 65535)));
        }
    }

    private void writeUnsignedShort(int positiveInt) throws IOException {
        Preconditions.checkArgument((positiveInt >= 0 ? 1 : 0) != 0, (Object)"positiveInt must be positive");
        this.out.write(positiveInt >>> 8 & 0xFF);
        this.out.write(positiveInt >>> 0 & 0xFF);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

