/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.johnson.event.RemoveEvent;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.stash.Product;
import com.atlassian.stash.concurrent.LockService;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.help.HelpPathService;
import com.atlassian.stash.home.HomeUpdate;
import com.atlassian.stash.home.HomeUpdateHandler;
import com.atlassian.stash.home.HomeUpdateHandlerModuleDescriptor;
import com.atlassian.stash.home.SimpleHomeUpdate;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"homeLockAcquirer"})
public class HomeTracker {
    private static final Logger log = LoggerFactory.getLogger(HomeTracker.class);
    private final EventPublisher eventPublisher;
    private final HelpPathService helpPathService;
    private final I18nService i18nService;
    private final LockService lockService;
    private final InternalApplicationPropertiesService propertiesService;

    @Autowired
    public HomeTracker(EventPublisher eventPublisher, HelpPathService helpPathService, I18nService i18nService, LockService lockService, InternalApplicationPropertiesService propertiesService) {
        this.eventPublisher = eventPublisher;
        this.helpPathService = helpPathService;
        this.i18nService = i18nService;
        this.lockService = lockService;
        this.propertiesService = propertiesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        Lock lock = this.lockService.getLock(HomeTracker.class.getName() + ".sharedHome");
        lock.lock();
        try {
            this.checkLastHomeDir(event);
        }
        finally {
            lock.unlock();
        }
    }

    private void checkLastHomeDir(PluginFrameworkStartedEvent event) {
        String sharedHomeDir = this.propertiesService.getSharedHomeDir().getAbsolutePath();
        String lastSharedHomeDir = this.propertiesService.getLastSharedHomeDir();
        if (lastSharedHomeDir == null) {
            log.info("Capturing benchmark shared home directory: {}", (Object)sharedHomeDir);
            this.propertiesService.setLastSharedHomeDir(sharedHomeDir);
        } else if (!lastSharedHomeDir.equals(sharedHomeDir)) {
            log.warn("The shared home directory has been moved from {} to {}", (Object)lastSharedHomeDir, (Object)sharedHomeDir);
            if (this.invokeHandlers(event.getPluginAccessor(), sharedHomeDir, lastSharedHomeDir)) {
                log.info("Updating benchmark shared home directory: {}", (Object)sharedHomeDir);
                this.propertiesService.setLastSharedHomeDir(sharedHomeDir);
            } else {
                log.warn("Not updating benchmark shared home directory. An update handler failed. Subsequent restarts will attempt to run the handlers again, unless the home directory is moved back to {}", (Object)lastSharedHomeDir);
            }
        }
    }

    private boolean invokeHandlers(PluginAccessor pluginAccessor, String newHomeDir, String oldHomeDir) {
        List descriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(HomeUpdateHandlerModuleDescriptor.class);
        if (CollectionUtils.isEmpty((Collection)descriptors)) {
            return true;
        }
        Collections.sort(descriptors);
        String helpTitle = this.helpPathService.getPageTitle("stash.help.home.directory");
        String helpUrl = this.helpPathService.getPageUrl("stash.help.home.directory");
        String message = this.i18nService.getMessage("stash.shared.home.updated", new Object[]{Product.NAME, helpTitle, helpUrl});
        Event lock = new Event(EventType.get((String)"home-updated"), message, EventLevel.get((String)"warning"));
        this.eventPublisher.publish((Object)new AddEvent((Object)this, lock));
        SimpleHomeUpdate update = new SimpleHomeUpdate.Builder().newDir(newHomeDir).oldDir(oldHomeDir).build();
        log.info("Invoking {} handler(s) after shared home directory update", (Object)descriptors.size());
        List handlers = Lists.transform((List)descriptors, (Function)new Function<HomeUpdateHandlerModuleDescriptor, HomeUpdateHandler>(){

            public HomeUpdateHandler apply(HomeUpdateHandlerModuleDescriptor descriptor) {
                return new DelegatingHomeUpdateHandler(descriptor);
            }
        });
        ArrayList successful = Lists.newArrayListWithCapacity((int)handlers.size());
        for (HomeUpdateHandler handler : handlers) {
            try {
                handler.apply((HomeUpdate)update);
                successful.add(handler);
            }
            catch (RuntimeException e) {
                String reason = e instanceof ServiceException ? e.getLocalizedMessage() : e.getMessage();
                lock.setDesc(this.i18nService.getMessage("stash.shared.home.updatefailed", new Object[]{Product.NAME, reason, helpTitle, helpUrl}));
                lock.setLevel(EventLevel.get((String)"fatal"));
                Collections.reverse(successful);
                for (HomeUpdateHandler revert : successful) {
                    revert.rollback((HomeUpdate)update);
                }
                return false;
            }
        }
        log.info("{} handler(s) have applied the home directory update successfully", (Object)handlers.size());
        this.eventPublisher.publish((Object)new RemoveEvent((Object)this, lock));
        return true;
    }

    private static class DelegatingHomeUpdateHandler
    implements HomeUpdateHandler {
        private final HomeUpdateHandlerModuleDescriptor descriptor;
        private final HomeUpdateHandler handler;

        private DelegatingHomeUpdateHandler(HomeUpdateHandlerModuleDescriptor descriptor) {
            this.descriptor = descriptor;
            this.handler = descriptor.getModule();
        }

        public void apply(HomeUpdate update) {
            log.debug("{}: Applying home update", (Object)this.descriptor.getCompleteKey());
            try {
                this.handler.apply(update);
            }
            catch (RuntimeException e) {
                log.error(this.descriptor.getCompleteKey() + ": Failed to apply home update", (Throwable)e);
                throw e;
            }
        }

        public void rollback(HomeUpdate update) {
            log.debug("{}: Rolling back successful home update", (Object)this.descriptor.getCompleteKey());
            try {
                this.handler.rollback(update);
            }
            catch (RuntimeException e) {
                log.error(this.descriptor.getCompleteKey() + ": Failed to rollback the home update after another " + "handler failed. This may have left some home directory contents in an inconsistent " + "state, with a mixture of references to the old and new locations.", (Throwable)e);
            }
        }
    }
}

