/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hazelcast;

import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.Capability;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HazelcastLifecycle
extends AbstractSmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(HazelcastLifecycle.class);
    private final HazelcastInstance hazelcast;
    private final int shutdownTimeout;

    @Autowired
    public HazelcastLifecycle(HazelcastInstance hazelcast, @Value(value="${hazelcast.partition.drain.timeout}") int shutdownTimeout) {
        this.hazelcast = hazelcast;
        this.shutdownTimeout = shutdownTimeout;
    }

    public int getPhase() {
        return 1500;
    }

    public void start() {
        log.info("Updating Hazelcast instance capabilities");
        this.hazelcast.getCluster().getLocalMember().updateCapabilities(EnumSet.allOf(Capability.class));
        super.start();
    }

    public void stop() {
        log.info("Draining partitions from local member");
        if (this.hazelcast.getPartitionService().drain((long)this.shutdownTimeout, TimeUnit.SECONDS)) {
            log.info("Drained local partitions");
        } else {
            log.warn("Timed out waiting for local partitions to be drained");
        }
        super.stop();
    }
}

