/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content.comment;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.comment.AbstractAddCommentRequest;
import com.atlassian.stash.comment.AddDiffCommentRequest;
import com.atlassian.stash.comment.AddFileCommentRequest;
import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.exception.ArgumentValidationException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.comment.AbstractCommentHelper;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.DiffCommentAnchorSearchCriteria;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.commit.CommitDiscussionCommentAnchorDao;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionCommentActivity;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionCommentAnchor;
import com.atlassian.stash.internal.content.comment.InternalCommitDiscussionCommentHelper;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.task.InternalTaskService;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="commitDiscussionCommentHelper")
public class DefaultCommitDiscussionCommentHelper
extends AbstractCommentHelper<InternalCommitDiscussion, InternalCommitDiscussionCommentAnchor>
implements InternalCommitDiscussionCommentHelper {
    private final RepositoryActivityDao activityDao;

    @Autowired
    public DefaultCommitDiscussionCommentHelper(RepositoryActivityDao activityDao, CommitDiscussionCommentAnchorDao anchorDao, StashAuthenticationContext authenticationContext, CommentDao commentDao, EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, CommentPostProcessor postProcessor, InternalTaskService taskService, Validator validator) {
        super(anchorDao, authenticationContext, commentDao, eventPublisher, i18nService, permissionService, postProcessor, taskService, validator);
        this.activityDao = activityDao;
    }

    @Override
    @Nonnull
    public InternalComment createDiffComment(@Nonnull InternalCommitDiscussion discussion, @Nonnull AddDiffCommentRequest request) {
        return super.createDiffComment(discussion, this.validateToHash(discussion, request));
    }

    @Override
    @Nonnull
    public InternalComment createFileComment(@Nonnull InternalCommitDiscussion discussion, @Nonnull AddFileCommentRequest request) {
        return super.createFileComment(discussion, this.validateToHash(discussion, request));
    }

    @Override
    @Nonnull
    public List<InternalCommitDiscussionCommentAnchor> findDiffAnchors(@Nonnull InternalCommitDiscussion discussion, @Nullable String parentId, @Nullable String path) {
        return this.search(discussion, new DiffCommentAnchorSearchCriteria().setFromHash(StringUtils.defaultString((String)parentId, (String)discussion.getParentId())).setPath(path).setToHash(discussion.getCommitId()));
    }

    @Override
    @Nullable
    public InternalCommitDiscussionCommentAnchor getAnchorByComment(@Nonnull InternalCommitDiscussion discussion, long commentId) {
        return ((CommitDiscussionCommentAnchorDao)this.anchorDao).getAnchorByComment(discussion, commentId);
    }

    @Override
    protected void addActivity(@Nonnull InternalCommitDiscussion discussion, @Nonnull InternalComment comment, InternalCommitDiscussionCommentAnchor anchor, @Nonnull CommentAction action, @Nonnull InternalStashUser user) {
        this.activityDao.create((Object)((InternalCommitDiscussionCommentActivity.Builder)((InternalCommitDiscussionCommentActivity.Builder)new InternalCommitDiscussionCommentActivity.Builder(discussion).comment(comment).commentAction(action).commentAnchor(anchor).createdDate(comment.getUpdatedDate())).user(user)).build());
    }

    @Override
    protected void deleteActivities(@Nonnull InternalCommitDiscussion discussion, @Nonnull InternalComment comment) {
        this.activityDao.deleteByComment(comment.getId().longValue());
    }

    @Override
    protected Function<InternalComment, InternalCommitDiscussionCommentAnchor> diffAnchor(@Nonnull InternalCommitDiscussion discussion, @Nonnull AddDiffCommentRequest request) {
        return new ChangesetDiffCommentAnchorFunction(discussion, (AbstractAddCommentRequest)request);
    }

    @Override
    protected Function<InternalComment, InternalCommitDiscussionCommentAnchor> fileAnchor(@Nonnull InternalCommitDiscussion discussion, @Nonnull AddFileCommentRequest request) {
        return new ChangesetDiffCommentAnchorFunction(discussion, (AbstractAddCommentRequest)request);
    }

    private <R extends AbstractAddCommentRequest> R validateToHash(InternalCommitDiscussion discussion, R request) {
        if (((AbstractAddCommentRequest)Preconditions.checkNotNull(request, (Object)"request")).getToHash() != null && !discussion.getCommitId().equals(request.getToHash())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("stash.discussion.comment.invalidtohash", new Object[]{request.getToHash(), discussion.getCommitId()}));
        }
        return request;
    }

    private static class ChangesetDiffCommentAnchorFunction
    implements Function<InternalComment, InternalCommitDiscussionCommentAnchor> {
        private final InternalCommitDiscussion discussion;
        private final AbstractAddCommentRequest request;

        public ChangesetDiffCommentAnchorFunction(InternalCommitDiscussion discussion, AbstractAddCommentRequest request) {
            this.discussion = discussion;
            this.request = request;
        }

        public InternalCommitDiscussionCommentAnchor apply(InternalComment comment) {
            return ((InternalCommitDiscussionCommentAnchor.Builder)((InternalCommitDiscussionCommentAnchor.Builder)((InternalCommitDiscussionCommentAnchor.Builder)((InternalCommitDiscussionCommentAnchor.Builder)new InternalCommitDiscussionCommentAnchor.Builder(this.discussion).apply(this.request)).comment(comment)).fromHash(StringUtils.defaultString((String)this.request.getFromHash(), (String)this.discussion.getParentId()))).toHash(this.discussion.getCommitId())).build();
        }
    }
}

