/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.fugue.Option;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.config.ConfigurationLineProcessor;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.config.DataSourceConfigAmendment;
import com.atlassian.stash.internal.config.FileOperationException;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.internal.hibernate.DefaultDataSourceConfiguration;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Service;

@Service(value="configurationService")
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private final StashAuthenticationContext authenticationContext;
    private final Clock clock;
    private final File sharedHomeDir;
    private final I18nService i18nService;

    @Autowired
    public ConfigurationServiceImpl(@Value(value="#{applicationSettings.sharedHomeDir}") File sharedHomeDir, StashAuthenticationContext authenticationContext, Clock clock, I18nService i18nService) {
        this.authenticationContext = (StashAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.sharedHomeDir = (File)Preconditions.checkNotNull((Object)sharedHomeDir);
        this.i18nService = (I18nService)Preconditions.checkNotNull((Object)i18nService);
    }

    @Nonnull
    public DataSourceConfiguration loadDataSourceConfiguration() throws IOException {
        Properties properties = this.loadCurrentConfig();
        return new DefaultDataSourceConfiguration(properties.getProperty("jdbc.driver"), properties.getProperty("jdbc.url"), properties.getProperty("jdbc.user"), properties.getProperty("jdbc.password"));
    }

    public void saveDataSourceConfiguration(@Nonnull DataSourceConfiguration dataSourceConfig) {
        this.saveDataSourceConfiguration(dataSourceConfig, (Option<String>)Option.none());
    }

    public void saveDataSourceConfiguration(@Nonnull DataSourceConfiguration dataSourceConfig, @Nonnull Option<String> message) {
        Preconditions.checkNotNull((Object)dataSourceConfig);
        Preconditions.checkNotNull(message);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        this.applyAmendment(new DataSourceConfigAmendment(dataSourceConfig, message, this.clock, currentUser));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void applyAmendment(DataSourceConfigAmendment amendment) {
        File original = this.stashConfigFile();
        File draft = this.createDraftConfigFile();
        BufferedWriter writer = this.openFile(draft);
        try {
            if (original.exists()) {
                this.backUpConfig(original);
                boolean amendmentWritten = this.processLines(original, new ConfigurationLineProcessor(writer, amendment));
                if (!amendmentWritten) {
                    amendment.writeTo(writer);
                }
            } else {
                amendment.writeTo(writer);
            }
            Closeables.closeQuietly((Closeable)writer);
            writer = null;
            this.rename(draft, original);
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
            if (draft != null && draft.exists() && !draft.delete()) {
                log.warn("Failed to delete draft Stash configuration file. Setting it to delete upon exit");
                draft.deleteOnExit();
            }
        }
    }

    private boolean processLines(File source, ConfigurationLineProcessor lineProcessor) {
        try {
            return (Boolean)Files.readLines((File)source, (Charset)Charsets.UTF_8, (LineProcessor)lineProcessor);
        }
        catch (IOException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.configuration.file.processing", new Object[]{source});
            throw new FileOperationException(message, e);
        }
    }

    private void rename(File draft, File target) {
        try {
            Files.move((File)draft, (File)target);
        }
        catch (IOException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.configuration.draft.rename", new Object[]{draft, target});
            throw new FileOperationException(message, e);
        }
    }

    private void backUpConfig(File original) {
        File backupFile = new File(original.getAbsolutePath() + ".bak");
        try {
            Files.copy((File)original, (File)backupFile);
        }
        catch (IOException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.configuration.configCopyFail", new Object[]{original, backupFile});
            throw new FileOperationException(message, e);
        }
    }

    private File stashConfigFile() {
        return new File(this.sharedHomeDir, "stash-config.properties");
    }

    private File createDraftConfigFile() {
        try {
            return File.createTempFile("draft", "properties", this.sharedHomeDir);
        }
        catch (IOException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.configuration.tempFile.create", new Object[0]);
            throw new FileOperationException(message, e);
        }
    }

    private Properties loadCurrentConfig() {
        Resource[] configResources = new Resource[]{new ClassPathResource("stash-internal.properties"), new ClassPathResource("stash-default.properties"), new FileSystemResource(this.stashConfigFile())};
        Properties properties = new Properties();
        for (Resource resource : configResources) {
            try {
                PropertiesLoaderUtils.fillProperties((Properties)properties, (Resource)resource);
            }
            catch (IOException e) {
                log.warn("Problem loading properties from {}", (Object)resource.getFilename(), (Object)e);
            }
        }
        return properties;
    }

    private BufferedWriter openFile(File file) {
        try {
            return Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.configuration.tempFile.notFound", new Object[]{file});
            throw new FileOperationException(message, e);
        }
    }
}

