/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.InternalChange;
import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.property.PropertyMap;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;

public class CommentCountChangeTransform
implements Function<Change, Change> {
    private static final String ACTIVE_COMMENTS = "activeComments";
    private static final String ORPHANED_COMMENTS = "orphanedComments";
    private final Map<InternalChangeLocation, CommentCounts> countsByLocation;

    public CommentCountChangeTransform(Map<InternalChangeLocation, CommentCounts> countsByLocation) {
        this.countsByLocation = (Map)Preconditions.checkNotNull(countsByLocation, (Object)"countsByLocation");
    }

    public Change apply(Change change) {
        CommentCounts counts = this.countsByLocation.get(new InternalChangeLocation.Builder(change).build());
        if (counts != null) {
            AttributeMap attributes = new AttributeMap.Builder().add(ACTIVE_COMMENTS, new String[]{String.valueOf(counts.getActive())}).add(ORPHANED_COMMENTS, new String[]{String.valueOf(counts.getOrphaned())}).build();
            PropertyMap properties = new PropertyMap.Builder().property(ACTIVE_COMMENTS, (Object)counts.getActive()).property(ORPHANED_COMMENTS, (Object)counts.getOrphaned()).build();
            InternalChange internalChange = (InternalChange)change;
            internalChange.setAttributes(attributes);
            internalChange.setProperties(properties);
        }
        return change;
    }
}

