/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.stash.internal.cluster.ClusterJoinCheck;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckAction;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckResult;
import com.atlassian.stash.internal.cluster.ClusterJoinRequest;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskState;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatus;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatusSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MaintenanceClusterJoinCheck
implements ClusterJoinCheck {
    private static final Logger log = LoggerFactory.getLogger(MaintenanceClusterJoinCheck.class);
    private static final String MAINTENANCE_MESSAGE = "The node is currently performing a maintenance task";
    private final MaintenanceTaskStatusSupplier statusHolder;

    @Autowired
    public MaintenanceClusterJoinCheck(@Qualifier(value="localMaintenanceTaskStatusSupplier") MaintenanceTaskStatusSupplier statusHolder) {
        this.statusHolder = statusHolder;
    }

    @Override
    @Nonnull
    public String getName() {
        return "migrationStatus";
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult accept(@Nonnull ClusterJoinRequest request) throws IOException {
        return this.checkMaintenanceTasks(request);
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult connect(@Nonnull ClusterJoinRequest request) throws IOException {
        return this.checkMaintenanceTasks(request);
    }

    public int getOrder() {
        return 10;
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult onUnknown(@Nonnull ClusterJoinRequest request) {
        return ClusterJoinCheckResult.OK;
    }

    private ClusterJoinCheckResult checkMaintenanceTasks(ClusterJoinRequest request) throws IOException {
        MaintenanceTaskStatus latestTask = this.statusHolder.get();
        String otherId = null;
        MaintenanceTaskState otherState = null;
        ObjectDataInput in = request.in();
        ObjectDataOutput out = request.out();
        if (latestTask == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(latestTask.getId());
            out.writeObject((Object)latestTask.getState());
        }
        if (in.readBoolean()) {
            otherId = in.readUTF();
            otherState = (MaintenanceTaskState)in.readObject();
        }
        if (latestTask == null) {
            if (otherState == MaintenanceTaskState.RUNNING) {
                return ClusterJoinCheckResult.passivate(ClusterJoinCheckAction.PASSIVATE_THIS_NODE, MAINTENANCE_MESSAGE);
            }
        } else {
            if (latestTask.getId().equals(otherId)) {
                if (latestTask.getState() != otherState) {
                    log.info("Local node reports {} maintenance task in state {} while the remote node reports state {}. Recovering from a network partition?", new Object[]{latestTask.getType(), latestTask.getState(), otherState});
                }
                return ClusterJoinCheckResult.OK;
            }
            if (latestTask.getState() == MaintenanceTaskState.RUNNING) {
                return ClusterJoinCheckResult.passivate(ClusterJoinCheckAction.PASSIVATE_OTHER_NODE, MAINTENANCE_MESSAGE);
            }
            if (otherState == MaintenanceTaskState.RUNNING) {
                return ClusterJoinCheckResult.passivate(ClusterJoinCheckAction.PASSIVATE_THIS_NODE, MAINTENANCE_MESSAGE);
            }
        }
        return ClusterJoinCheckResult.OK;
    }
}

