/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.stash.Product;
import com.atlassian.stash.auth.HttpAuthenticationFailureContext;
import com.atlassian.stash.auth.HttpAuthenticationFailureHandler;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.scm.AuthenticationState;
import com.atlassian.stash.scm.HttpScmRequestProvider;
import com.atlassian.stash.scm.http.HttpScmRequest;
import com.atlassian.stash.util.RequestUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ScmAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    public static final String SCM_SERVLET_PATH = "/scm";
    private final HttpScmRequestProvider httpScmRequestProvider;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;

    public ScmAuthenticationFailureHandler(HttpScmRequestProvider httpScmRequestProvider, I18nService i18nService, NavBuilder navBuilder) {
        this.httpScmRequestProvider = httpScmRequestProvider;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws IOException {
        String explanation;
        String title;
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        AuthenticationState authenticationState = context.getAuthenticationState();
        if (!SCM_SERVLET_PATH.equals(request.getServletPath())) {
            return false;
        }
        HttpScmRequest httpScmRequest = this.httpScmRequestProvider.getHttpScmRequest(request, response = RequestUtils.unwrap((HttpServletResponse)response));
        if (httpScmRequest == null) {
            return false;
        }
        switch (authenticationState) {
            case CAPTCHA_REQUIRED: {
                title = this.i18nService.getMessage("stash.scm.captcha.required", new Object[0]);
                explanation = this.i18nService.getMessage("stash.scm.captcha.required.detail", new Object[]{Product.NAME, this.navBuilder.buildAbsolute()});
                break;
            }
            case UNLICENSED: {
                title = this.i18nService.getMessage("stash.scm.no.licensed.user", new Object[0]);
                explanation = this.i18nService.getMessage("stash.scm.no.licensed.user.detail", new Object[]{Product.NAME});
                break;
            }
            default: {
                title = this.i18nService.getMessage("stash.scm.no.authentication", new Object[0]);
                explanation = this.i18nService.getMessage("stash.scm.no.authentication.detail", new Object[0]);
            }
        }
        httpScmRequest.sendAuthenticationError(authenticationState, title, explanation);
        return true;
    }
}

