/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.audit.AuditEntry;
import com.atlassian.stash.audit.Priority;
import com.atlassian.stash.event.audit.AuditEvent;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.request.RequestMetadata;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuditEventPublisher {
    private static final ObjectMapper objectMapperInstance = new ObjectMapper();
    protected static final Logger log = LoggerFactory.getLogger(AbstractAuditEventPublisher.class);
    protected final AuditEntryLoggingService auditLoggingService;
    protected final RequestManager requestManager;
    protected final StashAuthenticationContext authContext;
    protected final EventPublisher eventPublisher;

    protected AbstractAuditEventPublisher(AuditEntryLoggingService auditLoggingService, RequestManager requestManager, StashAuthenticationContext authContext, EventPublisher eventPublisher) {
        this.auditLoggingService = auditLoggingService;
        this.requestManager = requestManager;
        this.authContext = authContext;
        this.eventPublisher = eventPublisher;
    }

    protected String convertToJsonString(Object dataValues) throws IOException {
        return objectMapperInstance.writeValueAsString(dataValues);
    }

    protected StashUser getCurrentStashUser() {
        return this.authContext.getCurrentUser();
    }

    protected <T extends Exception> T logAndRethrow(Object event, T ex) throws T {
        AuditEntry.Builder builder = new AuditEntry.Builder().action("Publish AuditEvent").target(event.getClass().getSimpleName()).timestamp(new Date()).details("Failed to publish @Audited annotated event");
        this.setSourceIp(builder);
        this.auditLoggingService.log(builder.build());
        log.error("Failed to convert and publish @Audited annotated event {} of type {} due to {}. Note that AuditEntryConverter require a default no-args constructor.", new Object[]{event, event.getClass(), ex});
        throw ex;
    }

    protected void publish(Object event, AuditEntry auditEntry, Priority priority) throws Exception {
        this.publish(event, auditEntry, Collections.emptySet(), priority);
    }

    protected void publish(Object event, AuditEntry auditEntry, Set<String> channels, Priority priority) throws Exception {
        try {
            this.eventPublisher.publish((Object)new AuditEvent((Object)this, auditEntry, channels, priority));
        }
        catch (Exception ex) {
            this.auditLoggingService.log(auditEntry);
            throw this.logAndRethrow(event, ex);
        }
    }

    protected AuditEntry.Builder setCommonFields(Object event, AuditEntry.Builder builder) {
        return this.setSourceIp(builder).action(event.getClass().getSimpleName()).timestamp(new Date()).user(this.getCurrentStashUser());
    }

    protected AuditEntry.Builder setSourceIp(AuditEntry.Builder builder) {
        RequestMetadata context = this.requestManager.getRequestMetadata();
        if (context != null) {
            builder.sourceIpAddress(context.getRemoteAddress());
        }
        return builder;
    }
}

