/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.attach;

import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Either;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.exception.ArgumentValidationException;
import com.atlassian.stash.exception.DataStoreException;
import com.atlassian.stash.exception.NoSuchObjectException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.attach.AttachmentService;
import com.atlassian.stash.internal.attach.AttachmentSupplier;
import com.atlassian.stash.internal.attach.AttachmentsDisabledException;
import com.atlassian.stash.internal.config.Feature;
import com.atlassian.stash.internal.config.FeatureManager;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service(value="attachmentService")
public class DiskAttachmentService
implements AttachmentService {
    public static final String PATH_ATTACHMENTS = "attachments";
    private static final Logger log = LoggerFactory.getLogger(DiskAttachmentService.class);
    private final File attachmentsDir;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final SecureTokenGenerator tokenGenerator;

    @Autowired
    public DiskAttachmentService(FeatureManager featureManager, ApplicationSettings settings, I18nService i18nService, SecureTokenGenerator tokenGenerator) {
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.tokenGenerator = tokenGenerator;
        this.attachmentsDir = com.atlassian.stash.util.FileUtils.mkdir((File)settings.getDataDir(), (String)PATH_ATTACHMENTS);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public boolean delete(@Nonnull Repository repository, @Nonnull String id) {
        File attachment = this.findAttachment(repository, id);
        if (attachment.isFile() && attachment.delete()) {
            attachment.getParentFile().delete();
            log.debug("{}: Deleted attachment {}", (Object)repository, (Object)id);
            return true;
        }
        log.debug("{}: Attachment {} could not be deleted (Exists: {})", new Object[]{repository, id, attachment.exists()});
        return false;
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public long getSize(@Nonnull Repository repository) {
        File repositoryDir = this.getRepositoryDir(repository);
        return repositoryDir.isDirectory() ? FileUtils.sizeOfDirectory((File)repositoryDir) : 0L;
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        Repository repository = event.getRepository();
        File repositoryDir = this.getRepositoryDir(repository);
        if (repositoryDir.isDirectory()) {
            if (FileUtils.deleteQuietly((File)repositoryDir)) {
                log.info("{}: Deleted all attachments", (Object)repository);
            } else {
                log.warn("{}: Some attachments could not be deleted", (Object)repository);
            }
        } else {
            log.debug("{}: No attachments to delete", (Object)repository);
        }
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public AttachmentSupplier read(@Nonnull Repository repository, @Nonnull String id) {
        File attachment = this.findAttachment(repository, id);
        if (attachment.isFile()) {
            return new LoadedAttachmentSupplier(attachment);
        }
        throw new NoSuchObjectException(this.i18nService.createKeyedMessage("stash.attachment.nosuchattachment", new Object[]{id}), id);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public String save(@Nonnull Repository repository, @Nonnull AttachmentSupplier supplier) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)supplier, (Object)"supplier");
        this.checkFeatureEnabled();
        File tokenDir = this.createToken(repository);
        try {
            return this.writeAttachment(supplier, tokenDir);
        }
        catch (ServiceException e) {
            tokenDir.delete();
            throw e;
        }
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public List<Either<ServiceException, String>> saveAll(@Nonnull Repository repository, @Nonnull List<AttachmentSupplier> suppliers) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(suppliers, (Object)"suppliers");
        this.checkFeatureEnabled();
        if (suppliers.isEmpty()) {
            return Collections.emptyList();
        }
        File tokenDir = this.createToken(repository);
        ArrayList ids = Lists.newArrayListWithCapacity((int)suppliers.size());
        for (AttachmentSupplier supplier : suppliers) {
            Either result;
            try {
                result = Either.right((Object)this.writeAttachment(supplier, tokenDir));
            }
            catch (ServiceException e) {
                result = Either.left((Object)((Object)e));
            }
            ids.add(result);
        }
        return ids;
    }

    private void checkFeatureEnabled() {
        if (!this.featureManager.isEnabled(Feature.ATTACHMENTS)) {
            throw new AttachmentsDisabledException(this.i18nService.createKeyedMessage("stash.attachment.disabled", new Object[0]));
        }
    }

    private File createToken(Repository repository) {
        String token = this.tokenGenerator.generateToken();
        File repositoryDir = this.getRepositoryDir(repository);
        for (int i = 10; i < token.length(); ++i) {
            File tokenDir = new File(repositoryDir, token.substring(0, i));
            if (!tokenDir.mkdirs()) continue;
            return tokenDir;
        }
        throw new DataStoreException(this.i18nService.createKeyedMessage("stash.attachment.tokeninuse", new Object[0]));
    }

    private File findAttachment(Repository repository, String id) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)id, (Object)"id")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank ID is required");
        String[] paths = id.split("[\\\\/]");
        if (paths.length != 2 || "..".equals(paths[0])) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("stash.attachment.invalidid", new Object[]{id}));
        }
        return com.atlassian.stash.util.FileUtils.construct((File)this.getRepositoryDir(repository), (String[])new String[]{paths[0], paths[1]});
    }

    private File getRepositoryDir(Repository repository) {
        return com.atlassian.stash.util.FileUtils.construct((File)this.attachmentsDir, (String[])new String[]{"repository", String.valueOf(repository.getId())});
    }

    private String writeAttachment(AttachmentSupplier supplier, File tokenDir) {
        String name = supplier.getName();
        Preconditions.checkNotNull((Object)name, (Object)"supplier.name");
        if (name.contains("/") || name.contains("\\")) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("stash.attachment.invalidname", new Object[]{name}));
        }
        try {
            Files.copy((InputSupplier)supplier, (File)new File(tokenDir, name));
        }
        catch (IOException e) {
            throw new DataStoreException(this.i18nService.createKeyedMessage("stash.attachment.writefailed", new Object[]{name}), (Throwable)e);
        }
        return tokenDir.getName() + "/" + name;
    }

    private static class LoadedAttachmentSupplier
    implements AttachmentSupplier {
        private final File attachment;

        private LoadedAttachmentSupplier(File attachment) {
            this.attachment = attachment;
        }

        @Nonnull
        public InputStream getInput() throws IOException {
            return new FileInputStream(this.attachment);
        }

        @Nonnull
        public String getName() {
            return this.attachment.getName();
        }

        public long getSize() {
            return this.attachment.length();
        }
    }
}

