/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.webresource.util.HashBuilder;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.internal.util.InternalDateFormatter;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.util.DateFormatter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=DateFormatter.class)
@Component(value="dateFormatter")
public class DefaultDateFormatter
implements InternalDateFormatter {
    private final I18nService i18nService;
    private final Properties dateFormatProperties;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final InternalLocaleService localeService;
    private final String stateHash;

    @Autowired
    public DefaultDateFormatter(I18nService i18nService, ApplicationPropertiesService applicationPropertiesService, @Value(value="#{dateFormatProperties}") Properties dateFormatProperties, InternalLocaleService localeService) {
        this.dateFormatProperties = dateFormatProperties;
        this.i18nService = i18nService;
        this.applicationPropertiesService = applicationPropertiesService;
        this.localeService = localeService;
        this.stateHash = this.calculateState(dateFormatProperties);
    }

    private String calculateState(Properties properties) {
        HashBuilder builder = new HashBuilder();
        for (String propertyName : properties.stringPropertyNames()) {
            builder.add(propertyName + properties.getProperty(propertyName));
        }
        return builder.build();
    }

    public String getStateHash() {
        return this.stateHash;
    }

    public String formatDate(Date date, DateFormatter.FormatType type) {
        if (type.isAge()) {
            return this.formatDateWithRelativeAge(date, type.getKey());
        }
        return this.formatDateWithFormatString(date, type.getKey());
    }

    public String getFormatString(String key) {
        return this.dateFormatProperties.getProperty(key);
    }

    String formatDateWithFormatString(Date date, String key) {
        SimpleDateFormat format = new SimpleDateFormat(this.getFormatString(key), this.localeService.getLocale());
        format.setTimeZone(this.applicationPropertiesService.getDefaultTimeZone());
        return format.format(date);
    }

    String formatDateWithRelativeAge(Date date, String key) {
        return this.formatDateWithRelativeAge(new DateTime((Object)new Date()), new DateTime((Object)date), key);
    }

    String formatDateWithRelativeAge(DateTime now, DateTime date, String key) {
        if (!date.isAfter((ReadableInstant)now)) {
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.minutes((int)1)))) {
                return this.i18nService.getMessage(key + ".a.moment.ago", new Object[0]);
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.minutes((int)2)))) {
                return this.i18nService.getMessage(key + ".one.minute.ago", new Object[0]);
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.minutes((int)50)))) {
                return this.i18nService.getMessage(key + ".x.minutes.ago", new Object[]{this.getMinutesBetween(date, now)});
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.minutes((int)90)))) {
                return this.i18nService.getMessage(key + ".one.hour.ago", new Object[0]);
            }
            if (this.isYesterday(now, date) && date.isBefore((ReadableInstant)now.minus((ReadablePeriod)Period.hours((int)5)))) {
                return this.i18nService.getMessage(key + ".one.day.ago", new Object[0]);
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.days((int)1)))) {
                return this.i18nService.getMessage(key + ".x.hours.ago", new Object[]{this.getHoursBetween(date, now)});
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.days((int)7)))) {
                return this.i18nService.getMessage(key + ".x.days.ago", new Object[]{Math.max(this.getDaysBetween(date, now), 2)});
            }
            if (date.isAfter((ReadableInstant)now.minus((ReadablePeriod)Period.days((int)8)))) {
                return this.i18nService.getMessage(key + ".one.week.ago", new Object[0]);
            }
        }
        return this.formatDateWithFormatString(date.toDate(), key);
    }

    private boolean isYesterday(DateTime now, DateTime date) {
        DateTimeZone timeZone = DateTimeZone.forTimeZone((TimeZone)this.applicationPropertiesService.getDefaultTimeZone());
        DateTime end = now.withZone(timeZone).withTime(0, 0, 0, 0);
        DateTime start = end.minusDays(1);
        Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)end);
        return interval.contains((ReadableInstant)date);
    }

    private int getMinutesBetween(DateTime start, DateTime end) {
        return new Period((ReadableInstant)start, (ReadableInstant)end).getMinutes();
    }

    private int getHoursBetween(DateTime start, DateTime end) {
        Period period = new Period((ReadableInstant)start, (ReadableInstant)end);
        int hours = period.getHours();
        if (period.getMinutes() >= 30) {
            ++hours;
        }
        return hours;
    }

    private int getDaysBetween(DateTime start, DateTime end) {
        return new Period((ReadableInstant)start, (ReadableInstant)end).getDays();
    }
}

