/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.comment.NoSuchCommentException;
import com.atlassian.stash.event.task.TaskCreatedEvent;
import com.atlassian.stash.event.task.TaskDeletedEvent;
import com.atlassian.stash.event.task.TaskUpdatedEvent;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipantHelper;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.task.InternalTask;
import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.internal.task.InternalTaskSearchRequest;
import com.atlassian.stash.internal.task.InternalTaskService;
import com.atlassian.stash.internal.task.TaskDao;
import com.atlassian.stash.internal.task.TaskPermissionsHelper;
import com.atlassian.stash.internal.task.TaskPostProcessor;
import com.atlassian.stash.internal.task.enrich.TaskEnricher;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.task.IllegalTaskStateException;
import com.atlassian.stash.task.NoSuchTaskException;
import com.atlassian.stash.task.Task;
import com.atlassian.stash.task.TaskAnchor;
import com.atlassian.stash.task.TaskCount;
import com.atlassian.stash.task.TaskCreateRequest;
import com.atlassian.stash.task.TaskService;
import com.atlassian.stash.task.TaskState;
import com.atlassian.stash.task.TaskUpdateRequest;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=TaskService.class)
@Service(value="taskService")
public class DefaultTaskService
implements InternalTaskService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskService.class);
    private final StashAuthenticationContext authenticationContext;
    private final CommentDao commentDao;
    private final I18nService i18nService;
    private final InternalPullRequestParticipantHelper participantHelper;
    private final PermissionService permissionService;
    private final PullRequestDao pullRequestDao;
    private final TaskDao taskDao;
    private final TaskEnricher taskEnricher;
    private final TaskPermissionsHelper taskPermissionsHelper;
    private final TaskPostProcessor taskPostProcessor;
    private final EventPublisher eventPublisher;
    private final int maxAnchorsPerRequest;
    private final int maxContextsPerRequest;
    private final int maxTasksPerRequest;

    @Autowired
    public DefaultTaskService(StashAuthenticationContext authenticationContext, CommentDao commentDao, EventPublisher eventPublisher, I18nService i18nService, @Value(value="${task.max.anchors.per.request}") int maxAnchorsPerRequest, @Value(value="${task.max.contexts.per.request}") int maxContextsPerRequest, @Value(value="${task.max.tasks.per.request}") int maxTasksPerRequest, InternalPullRequestParticipantHelper participantHelper, PermissionService permissionService, PullRequestDao pullRequestDao, TaskDao taskDao, TaskEnricher taskEnricher, TaskPermissionsHelper taskPermissionsHelper, TaskPostProcessor taskPostProcessor) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.commentDao = commentDao;
        this.i18nService = i18nService;
        this.maxAnchorsPerRequest = maxAnchorsPerRequest;
        this.maxContextsPerRequest = maxContextsPerRequest;
        this.maxTasksPerRequest = maxTasksPerRequest;
        this.participantHelper = participantHelper;
        this.permissionService = permissionService;
        this.pullRequestDao = pullRequestDao;
        this.taskDao = taskDao;
        this.taskEnricher = taskEnricher;
        this.taskPermissionsHelper = taskPermissionsHelper;
        this.taskPostProcessor = taskPostProcessor;
    }

    @Nonnull
    @Transactional
    @Unsecured(value="Internal interface method")
    public TaskCount count(@Nonnull InternalTaskSearchRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        request = this.restrictAnchors(request);
        return this.taskDao.count(request);
    }

    @Nonnull
    @Transactional
    @Unsecured(value="Instances of TaskContext imply that the permissions to obtain them was already performed")
    public <T extends InternalTaskContext> Map<T, TaskCount> countForContexts(@Nonnull Iterable<T> contexts) {
        Preconditions.checkNotNull(contexts, (Object)"contexts");
        contexts = this.restrictContexts(contexts);
        return this.taskDao.countForContexts(contexts);
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    @Transactional
    public Task create(@Nonnull TaskCreateRequest request) {
        InternalPullRequest context;
        InternalComment anchor;
        Preconditions.checkNotNull((Object)request, (Object)"request");
        switch (request.getAnchorType()) {
            case COMMENT: {
                anchor = this.getCommentOrFail(request.getAnchorId());
                InternalPullRequest pullRequest = this.getContextOrFail(request.getAnchorId());
                this.validateContextIsVisible((InternalTaskContext)pullRequest);
                this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
                context = pullRequest;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown anchor type: " + request.getAnchorType());
            }
        }
        InternalStashUser author = InternalConverter.convertToInternalUser((StashUser)this.authenticationContext.getCurrentUser());
        InternalTask taskToCreate = new InternalTask.Builder().anchor((TaskAnchor)anchor).author(author).context((InternalTaskContext)context).createdDate(new Date()).text(this.normalizeText(request.getText())).build();
        InternalTask task = this.taskPostProcessor.process((InternalTask)this.taskDao.create((Object)taskToCreate));
        this.eventPublisher.publish((Object)new TaskCreatedEvent((Object)this, (Task)task));
        return task;
    }

    @Secured(value="Permission check performed internally")
    @Transactional
    public void delete(long taskId) {
        InternalTask taskToDelete = this.getById(taskId);
        if (taskToDelete == null) {
            throw new NoSuchTaskException(this.i18nService.createKeyedMessage("stash.service.task.nosuchtask", new Object[]{taskId}));
        }
        this.validateTaskCanBeDeleted(taskToDelete);
        this.taskDao.delete((Object)taskToDelete);
        this.eventPublisher.publish((Object)new TaskDeletedEvent((Object)this, (Task)taskToDelete));
    }

    @Nullable
    @Secured(value="Permission check performed internally")
    @Transactional
    public InternalTask getById(long taskId) {
        InternalTask task = (InternalTask)this.taskDao.getById((Object)taskId);
        if (task == null || !this.permissionService.hasRepositoryPermission(task.getContext().getScopeRepository(), Permission.REPO_READ)) {
            return null;
        }
        return this.taskPostProcessor.process(task);
    }

    @Transactional
    @Unsecured(value="An instance of TaskAnchor implies that the permission to obtain it was already verified")
    public boolean hasTasks(@Nonnull TaskAnchor anchor) {
        Preconditions.checkNotNull((Object)anchor, (Object)"anchor");
        return this.taskDao.hasTasks(anchor);
    }

    @Nonnull
    @Transactional
    @Unsecured(value="Internal interface method")
    public Page<Task> search(@Nonnull InternalTaskSearchRequest searchRequest, @Nonnull PageRequest pageRequest, boolean withProperties) {
        Preconditions.checkNotNull((Object)searchRequest, (Object)"searchRequest");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        searchRequest = this.restrictAnchors(searchRequest);
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxTasksPerRequest);
        Page page = this.taskDao.search(searchRequest, pageRequest);
        this.taskPostProcessor.processAll(searchRequest.getContext(), page.getValues());
        if (withProperties) {
            this.taskEnricher.enrich(searchRequest.getContext(), page.getValues());
        }
        return PageUtils.asPageOf(Task.class, (Page)page);
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    @Transactional
    public Task update(@Nonnull TaskUpdateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalTask taskToUpdate = InternalConverter.convertToInternalTask((Task)request.getTask());
        InternalTaskContext context = taskToUpdate.getContext();
        this.validateContextIsVisible(context);
        InternalTask.Builder update = new InternalTask.Builder(taskToUpdate);
        if (request.getState() != null) {
            update.state(request.getState());
        }
        if (request.getText() != null && !request.getText().equals(taskToUpdate.getText())) {
            this.validateTaskCanBeUpdated(taskToUpdate);
            update.text(this.normalizeText(request.getText()));
        }
        InternalTask task = this.taskPostProcessor.process((InternalTask)this.taskDao.update((Object)update.build()));
        this.updateParticipant(task.getContext());
        this.eventPublisher.publish((Object)new TaskUpdatedEvent((Object)this, (Task)task, taskToUpdate.getState(), taskToUpdate.getText()));
        return task;
    }

    private void updateParticipant(InternalTaskContext context) {
        if (context instanceof InternalPullRequest) {
            this.participantHelper.makeCurrentUserParticipantAndWatcher((InternalPullRequest)context);
        }
    }

    @Nonnull
    private InternalComment getCommentOrFail(long commentId) {
        InternalComment comment = (InternalComment)this.commentDao.getById((Object)commentId);
        if (comment == null) {
            throw new NoSuchCommentException(this.i18nService.createKeyedMessage("stash.service.comment.nosuchcomment", new Object[0]));
        }
        return comment;
    }

    @Nonnull
    private InternalPullRequest getContextOrFail(long commentId) {
        InternalPullRequest pullRequest = this.pullRequestDao.findByComment(commentId);
        if (pullRequest == null) {
            throw new NoSuchCommentException(this.i18nService.createKeyedMessage("stash.service.comment.nosuchcomment", new Object[0]));
        }
        return pullRequest;
    }

    private InternalTaskSearchRequest restrictAnchors(InternalTaskSearchRequest request) {
        Set anchorIds = request.getAnchorIds();
        if (anchorIds.size() > this.maxAnchorsPerRequest) {
            log.warn("Restricting the search to the first {} anchors (out of {} total)", (Object)this.maxAnchorsPerRequest, (Object)anchorIds.size());
            ArrayList restricted = new ArrayList(this.maxAnchorsPerRequest);
            Iterables.addAll(restricted, (Iterable)Iterables.limit((Iterable)anchorIds, (int)this.maxAnchorsPerRequest));
            return new InternalTaskSearchRequest.Builder(request.getContext()).anchors(restricted, request.getAnchorType()).build();
        }
        return request;
    }

    private <T extends InternalTaskContext> Iterable<T> restrictContexts(Iterable<T> contexts) {
        return Iterables.limit(contexts, (int)this.maxContextsPerRequest);
    }

    private void validateContextIsVisible(InternalTaskContext context) {
        if (!this.permissionService.hasRepositoryPermission(context.getScopeRepository(), Permission.REPO_READ)) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("stash.service.task.nosuchcontext", new Object[]{context.getId()}));
        }
    }

    private void validateTaskCanBeDeleted(InternalTask task) {
        if (!this.isAuthorizedToUpdateOrDelete(task)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("stash.service.task.delete.unauthorized", new Object[0]));
        }
        if (task.getState().equals((Object)TaskState.RESOLVED)) {
            throw new IllegalTaskStateException(this.i18nService.createKeyedMessage("stash.service.task.delete.illegal", new Object[0]), TaskState.RESOLVED);
        }
    }

    private void validateTaskCanBeUpdated(InternalTask internalTask) {
        if (!this.isAuthorizedToUpdateOrDelete(internalTask)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("stash.service.task.update.unauthorized", new Object[0]));
        }
        if (internalTask.getState().equals((Object)TaskState.RESOLVED)) {
            throw new IllegalTaskStateException(this.i18nService.createKeyedMessage("stash.service.task.update.illegal", new Object[0]), TaskState.RESOLVED);
        }
    }

    private boolean isAuthorizedToUpdateOrDelete(InternalTask task) {
        InternalTaskContext context = task.getContext();
        boolean isRepoAdmin = this.taskPermissionsHelper.isRepoAdmin(context.getScopeRepository());
        return isRepoAdmin || this.taskPermissionsHelper.hasFullPermission(context, task);
    }

    private String normalizeText(String originalText) {
        return CharMatcher.JAVA_WHITESPACE.trimAndCollapseFrom((CharSequence)originalText, ' ');
    }
}

