/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.scm.HttpScmRequestProvider;
import com.atlassian.stash.scm.http.HttpScmRequest;
import com.atlassian.stash.scm.http.HttpScmRequestHandler;
import com.atlassian.stash.scm.http.HttpScmRequestHandlerModuleDescriptor;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=HttpScmRequestProvider.class)
@Component(value="httpScmRequestProvider")
public class PluginHttpScmRequestProvider
implements HttpScmRequestProvider {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginHttpScmRequestProvider(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public HttpScmRequest getHttpScmRequest(HttpServletRequest req, HttpServletResponse resp) {
        HttpScmRequestHandler handler;
        HttpScmRequest httpScmRequest = null;
        Iterator<HttpScmRequestHandler> i$ = this.getHandlers().iterator();
        while (i$.hasNext() && (httpScmRequest = (handler = i$.next()).create(req, resp)) == null) {
        }
        return httpScmRequest;
    }

    private Iterable<HttpScmRequestHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpScmRequestHandlerModuleDescriptor.class));
    }
}

