/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.request;

import com.atlassian.cache.Supplier;
import com.atlassian.stash.request.RequestContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;

public class RequestLocalCache<K, V> {
    private final RequestContext requestContext;
    private final ThreadLocal<Map<K, V>> cache;

    public RequestLocalCache(final RequestContext requestContext) {
        this.requestContext = requestContext;
        this.cache = new ThreadLocal<Map<K, V>>(){

            @Override
            protected Map<K, V> initialValue() {
                requestContext.addCleanupCallback(new Runnable(){

                    @Override
                    public void run() {
                        RequestLocalCache.this.cache.remove();
                    }
                });
                return Maps.newHashMap();
            }
        };
    }

    public V get(@Nonnull K key, @Nonnull Supplier<V> loader) {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkNotNull(loader, (Object)"loader");
        if (this.requestContext.isActive() && this.cache.get().containsKey(key)) {
            return this.cache.get().get(key);
        }
        Object value = loader.get();
        if (this.requestContext.isActive()) {
            this.cache.get().put(key, value);
        }
        return (V)value;
    }
}

