/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.RewriteExceptions;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.repository.RepositorySupplier;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.springframework.security.access.prepost.PostAuthorize;

@RewriteExceptions
public class DefaultRepositorySupplier
extends AbstractService
implements RepositorySupplier {
    protected final RepositoryDao repositoryDao;

    public DefaultRepositorySupplier(RepositoryDao repositoryDao) {
        this.repositoryDao = repositoryDao;
    }

    @PostAuthorize(value="isRepositoryAccessible(returnObject)")
    public InternalRepository getById(int id) {
        return (InternalRepository)this.repositoryDao.getById((Object)id);
    }

    @PostAuthorize(value="isRepositoryAccessible(returnObject)")
    public InternalRepository getBySlug(@Nonnull String projectKey, @Nonnull String slug) {
        Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey");
        Preconditions.checkNotNull((Object)slug, (Object)"slug");
        return this.repositoryDao.getBySlug(projectKey, slug);
    }
}

