/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Diff;
import com.atlassian.stash.content.DiffHunk;
import com.atlassian.stash.content.InternalDiff;
import com.atlassian.stash.content.InternalDiffHunk;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalDiffCommentAnchor;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextLine;
import com.atlassian.stash.property.PropertyMap;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DiffComment {
    private final InternalPullRequestCommentActivity activity;
    private final InternalDiffCommentAnchor anchor;
    private final AttributeMap attributes;
    private final InternalComment comment;
    private final PropertyMap properties;

    public DiffComment(@Nonnull InternalPullRequestCommentActivity activity, @Nonnull AttributeMap attributes, @Nonnull PropertyMap properties) {
        this.activity = (InternalPullRequestCommentActivity)Preconditions.checkNotNull((Object)activity, (Object)"An activity is required");
        this.attributes = (AttributeMap)Preconditions.checkNotNull((Object)attributes, (Object)"attributes");
        this.properties = (PropertyMap)Preconditions.checkNotNull((Object)properties, (Object)"properties");
        this.anchor = (InternalDiffCommentAnchor)Preconditions.checkNotNull((Object)activity.getCommentAnchor(), (Object)"Only anchored comments support gathering context");
        this.comment = activity.getComment();
    }

    public void applyDiff(@Nonnull InternalDiffHunk hunk) {
        InternalDiff.Builder diffBuilder = (InternalDiff.Builder)((InternalDiff.Builder)new InternalDiff.Builder().attributes(this.attributes)).destination(this.anchor.getPath()).hunk((DiffHunk)hunk).properties((Map)this.properties);
        if (StringUtils.isNotBlank((String)this.anchor.getSrcPath())) {
            diffBuilder.source(this.anchor.getSrcPath());
        }
        this.activity.setDiff((Diff)diffBuilder.build());
    }

    public long getId() {
        return this.comment.getId();
    }

    public boolean isDiffApplied() {
        return this.activity.getDiff() != null;
    }

    public boolean isAnchoredOn(@Nonnull DiffContextLine line) {
        return line.isAnchor(this.anchor);
    }
}

