/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.concurrent.PullRequestLock;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.PullRequestStateGuard;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.UncheckedOperation;
import com.hazelcast.core.IMap;
import com.hazelcast.map.AbstractEntryProcessor;
import com.hazelcast.map.EntryProcessor;
import java.util.Map;
import javax.annotation.Nonnull;

public class HazelcastPullRequestStateGuard
implements PullRequestStateGuard {
    private final PullRequestLock pullRequestLock;
    private final IMap<Long, Integer> pendingUpdatesCount;

    public HazelcastPullRequestStateGuard(PullRequestLock pullRequestLock, IMap<Long, Integer> pendingUpdatesCount) {
        this.pullRequestLock = pullRequestLock;
        this.pendingUpdatesCount = pendingUpdatesCount;
    }

    public void updated(@Nonnull InternalPullRequest pullRequest) {
        try (Timer ignored = TimerUtils.start((String)"StateGuard.update");){
            this.pendingUpdatesCount.executeOnKey((Object)pullRequest.getGlobalId(), (EntryProcessor)new PendingUpdatesModifier(1));
        }
    }

    public void processIfUpdated(@Nonnull InternalPullRequest pullRequest, final @Nonnull UncheckedOperation<Void> updateOperation) {
        try (Timer timer = TimerUtils.start((String)"StateGuard.processIfUpdated - check");){
            final Long pullRequestGlobalId = pullRequest.getGlobalId();
            if (this.getPendingUpdatesCount(pullRequestGlobalId) == 0) {
                return;
            }
            timer.mark("StateGuard.processIfUpdated - lock");
            this.pullRequestLock.withLock((PullRequest)pullRequest, (Operation)new UncheckedOperation<Object>(){

                public Object perform() {
                    int updateCount = HazelcastPullRequestStateGuard.this.getPendingUpdatesCount(pullRequestGlobalId);
                    if (updateCount > 0) {
                        updateOperation.perform();
                        HazelcastPullRequestStateGuard.this.pendingUpdatesCount.executeOnKey((Object)pullRequestGlobalId, (EntryProcessor)new PendingUpdatesModifier(-updateCount));
                    }
                    return null;
                }
            });
        }
    }

    private int getPendingUpdatesCount(Long pullRequestGlobalId) {
        Integer oldUpdatesCount = (Integer)this.pendingUpdatesCount.putIfAbsent((Object)pullRequestGlobalId, (Object)1);
        return oldUpdatesCount == null ? 1 : oldUpdatesCount;
    }

    private static class PendingUpdatesModifier
    extends AbstractEntryProcessor<Long, Integer> {
        private final int modifier;

        private PendingUpdatesModifier(int modifier) {
            this.modifier = modifier;
        }

        public Object process(Map.Entry<Long, Integer> entry) {
            Integer val = entry.getValue();
            if (val == null) {
                entry.setValue(this.modifier);
            } else {
                entry.setValue(val + this.modifier);
            }
            return null;
        }
    }
}

