/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.RewriteExceptions;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.project.ProjectSupplier;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.springframework.security.access.prepost.PostAuthorize;

@RewriteExceptions
public class DefaultProjectSupplier
extends AbstractService
implements ProjectSupplier {
    protected final ProjectDao projectDao;

    public DefaultProjectSupplier(ProjectDao projectDao) {
        this.projectDao = projectDao;
    }

    @PostAuthorize(value="isProjectAccessible(returnObject)")
    public InternalProject getById(int id) {
        return (InternalProject)this.projectDao.getById((Object)id);
    }

    @PostAuthorize(value="isProjectAccessible(returnObject)")
    public InternalProject getByKey(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        return this.projectDao.getByKey(key);
    }

    @PostAuthorize(value="isProjectAccessible(returnObject)")
    public InternalProject getByName(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.projectDao.getByName(name);
    }
}

