/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.latch;

import com.hazelcast.core.Member;
import com.hazelcast.core.MultiExecutionCallback;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultCollectingExecutionCallback<T>
implements MultiExecutionCallback {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CountDownLatch completeLatch = new CountDownLatch(1);
    protected final AtomicBoolean status = new AtomicBoolean(true);

    public void onResponse(Member member, Object o) {
        if (o instanceof Throwable) {
            this.log.warn("Error while executing on {}", (Object)member, o);
            this.status.compareAndSet(true, false);
            this.onError(member, (Throwable)o);
        } else {
            this.log.debug("Success executing on {}. Result: {}", (Object)member, o);
            this.onSuccess(member, o);
        }
    }

    public void onComplete(Map<Member, Object> memberObjectMap) {
        this.log.debug("Execution complete. Successful - {}", (Object)this.isSuccess());
        this.completeLatch.countDown();
    }

    public void await() throws InterruptedException {
        this.completeLatch.await();
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.completeLatch.await(timeout, timeUnit);
    }

    public boolean isSuccess() {
        return this.status.get();
    }

    protected void onError(Member member, Throwable throwable) {
    }

    protected void onSuccess(Member member, T value) {
        this.onSuccess(value);
    }

    protected void onSuccess(T value) {
    }
}

