/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.RemoveEvent;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.atlassian.stash.event.maintenance.MaintenanceEndedEvent;
import com.atlassian.stash.event.maintenance.MaintenanceStartedEvent;
import com.atlassian.stash.internal.maintenance.JohnsonMaintenanceEvent;
import com.atlassian.stash.internal.maintenance.MaintenanceModeHelper;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaintenanceModeHelper
implements MaintenanceModeHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultMaintenanceModeHelper.class);
    private final EventPublisher eventPublisher;
    private final LifecycleAwareSchedulerService schedulerService;

    public DefaultMaintenanceModeHelper(EventPublisher eventPublisher, LifecycleAwareSchedulerService schedulerService) {
        this.eventPublisher = eventPublisher;
        this.schedulerService = schedulerService;
    }

    @Override
    public void lock(@Nonnull JohnsonMaintenanceEvent event) {
        this.pauseScheduler();
        this.eventPublisher.publish((Object)new MaintenanceStartedEvent((Object)this));
        this.eventPublisher.publish((Object)new AddEvent((Object)this, (Event)event));
    }

    @Override
    public void unlock(@Nonnull JohnsonMaintenanceEvent event) {
        this.eventPublisher.publish((Object)new RemoveEvent((Object)this, (Event)event));
        this.eventPublisher.publish((Object)new MaintenanceEndedEvent((Object)this));
        this.resumeScheduler();
    }

    private void pauseScheduler() {
        try {
            this.schedulerService.standby();
        }
        catch (SchedulerServiceException e) {
            log.warn("The scheduler threw an exception when it was paused. This usually means the scheduler has already been shutdown.", (Throwable)e);
        }
    }

    private void resumeScheduler() {
        try {
            this.schedulerService.start();
        }
        catch (SchedulerServiceException e) {
            log.warn("The scheduler threw an exception when it was resumed. This usually means some jobs missed their configured start time while the scheduler was paused.", (Throwable)e);
        }
    }
}

