/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.commit.CommitEnricher;
import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.idx.ChangesetIndex;
import com.atlassian.stash.idx.CommitIndex;
import com.atlassian.stash.idx.IndexSearchRequest;
import com.atlassian.stash.idx.IndexedChangeset;
import com.atlassian.stash.idx.IndexedCommit;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.content.IndexedChangesetDao;
import com.atlassian.stash.internal.idx.InternalIndexedChangeset;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={ChangesetIndex.class, CommitIndex.class})
@Component(value="changesetIndex")
@Transactional(readOnly=true)
public class DbChangesetIndex
implements CommitIndex,
ChangesetIndex {
    public static final Function<PropertyMap, AttributeMap> PROPERTIES_TO_ATTRIBUTES = new Function<PropertyMap, AttributeMap>(){

        public AttributeMap apply(PropertyMap input) {
            return new AttributeMap.Builder().add((Map)input).build();
        }
    };
    private final Predicate<Repository> canReadRepositoryPredicate;
    private final IndexedChangesetDao changesetDao;
    @Autowired
    private CommitEnricher commitEnricher;
    @Value(value="${page.max.index.results}")
    private int maxIndexResults;

    @Autowired
    public DbChangesetIndex(IndexedChangesetDao changesetDao, PermissionPredicateFactory predicateFactory) {
        this.canReadRepositoryPredicate = predicateFactory.createRepositoryAccessiblePredicate();
        this.changesetDao = changesetDao;
    }

    @Deprecated
    @Transactional
    public void addAttribute(@Nonnull String changesetId, @Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull((Object)changesetId, (Object)"changesetId");
        Preconditions.checkNotNull((Object)name, (Object)"attributeName");
        Preconditions.checkNotNull((Object)value, (Object)"attributeValue");
        this.addProperty(changesetId, name, value);
    }

    @Transactional
    public void addChangeset(@Nonnull Changeset changeset, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)changeset, (Object)"changeset");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        InternalIndexedChangeset cs = (InternalIndexedChangeset)this.changesetDao.getById((Object)changeset.getId());
        if (cs == null) {
            cs = new InternalIndexedChangeset(changeset.getId(), changeset.getAuthorTimestamp());
            this.changesetDao.create((Object)cs);
        }
        if (!DbChangesetIndex.isPersonalFork(repository)) {
            this.changesetDao.addMembership(cs, InternalConverter.convertToInternalRepository((Repository)repository));
        }
    }

    @Transactional
    public void addProperty(@Nonnull String commitId, @Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull((Object)commitId, (Object)"commitId");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        this.changesetDao.addProperty((InternalIndexedChangeset)this.changesetDao.getById((Object)commitId), key, value);
    }

    @Nonnull
    public Changeset enrichChangeset(@Nonnull Changeset changeset, @Nonnull Repository repository, Collection<String> attributeNames) {
        return this.commitEnricher.enrich(repository, changeset, attributeNames);
    }

    @Nonnull
    public Page<Changeset> enrichChangesets(@Nonnull Page<Changeset> changesets, @Nonnull Repository repository, Collection<String> attributeNames) {
        return this.commitEnricher.enrich(repository, changesets, attributeNames);
    }

    @Nonnull
    public Page<IndexedCommit> findByProperty(final @Nonnull String propertyKey, final @Nonnull String propertyValue, final boolean caseSensitive, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)propertyKey, (Object)"propertyKey");
        Preconditions.checkNotNull((Object)propertyValue, (Object)"propertyValue");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxIndexResults);
        PageProvider<IndexedCommit> pageProvider = new PageProvider<IndexedCommit>(){

            public Page<IndexedCommit> get(PageRequest request) {
                return DbChangesetIndex.this.changesetDao.findByProperty(propertyKey, propertyValue, caseSensitive, request).transform((Function)new Function<InternalIndexedChangeset, IndexedCommit>(){

                    public IndexedCommit apply(InternalIndexedChangeset changeset) {
                        return DbChangesetIndex.this.transformForPermissions(changeset);
                    }
                });
            }
        };
        return PageUtils.filterPages((PageProvider)pageProvider, (Predicate)new Predicate<IndexedCommit>(){

            public boolean apply(IndexedCommit commit) {
                return !commit.getRepositories().isEmpty();
            }
        }, (PageRequest)pageRequest);
    }

    @Deprecated
    @Nonnull
    public Page<IndexedChangeset> findChangesetsByAttribute(@Nonnull String attributeName, @Nonnull String attributeValue, boolean caseSensitive, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)attributeName, (Object)"attributeName");
        Preconditions.checkNotNull((Object)attributeValue, (Object)"attributeValue");
        return PageUtils.asPageOf(IndexedChangeset.class, this.findByProperty(attributeName, attributeValue, caseSensitive, pageRequest));
    }

    @Deprecated
    @Nonnull
    public AttributeMap getAttributeValues(@Nonnull String csid, @Nonnull Collection<String> attributeNames) {
        return (AttributeMap)PROPERTIES_TO_ATTRIBUTES.apply((Object)this.getProperties(csid, attributeNames));
    }

    @Deprecated
    @Nonnull
    public Map<String, AttributeMap> getAttributeValues(@Nonnull Collection<String> csids, @Nonnull Collection<String> attributeNames) {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.getProperties(csids, attributeNames), PROPERTIES_TO_ATTRIBUTES));
    }

    public IndexedChangeset getChangeset(@Nonnull String csid) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        IndexedChangeset cs = (IndexedChangeset)this.changesetDao.getById((Object)csid);
        if (cs != null && Iterables.any((Iterable)cs.getRepositories(), this.canReadRepositoryPredicate)) {
            return cs;
        }
        return null;
    }

    @Nonnull
    public PropertyMap getProperties(@Nonnull String commitId, @Nonnull Iterable<String> propertyKeys) {
        Preconditions.checkNotNull((Object)commitId, (Object)"commitId");
        Preconditions.checkNotNull(propertyKeys, (Object)"propertyKeys");
        return this.changesetDao.getProperties(commitId, propertyKeys);
    }

    @Nonnull
    public Map<String, PropertyMap> getProperties(@Nonnull Iterable<String> commitIds, @Nonnull Iterable<String> propertyKeys) {
        Preconditions.checkNotNull(commitIds, (Object)"commitIds");
        Preconditions.checkNotNull(propertyKeys, (Object)"propertyKeys");
        return this.changesetDao.getProperties(commitIds, propertyKeys);
    }

    public boolean isMemberOf(@Nonnull String changesetId, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)changesetId, (Object)"changesetId");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        return this.canReadRepositoryPredicate.apply((Object)repository) && this.changesetDao.isMemberOf(changesetId, InternalConverter.convertToInternalRepository((Repository)repository));
    }

    @Deprecated
    @Transactional
    public void removeAttribute(@Nonnull String csid, @Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        Preconditions.checkNotNull((Object)name, (Object)"attributeName");
        Preconditions.checkNotNull((Object)value, (Object)"attributeValue");
        this.removeProperty(csid, name, value);
    }

    @Transactional
    public void removeChangeset(@Nonnull String csid, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        this.changesetDao.deleteMembership(csid, InternalConverter.convertToInternalRepository((Repository)repository));
    }

    @Transactional
    public void removeProperty(@Nonnull String commitId, @Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull((Object)commitId, (Object)"commitId");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        this.changesetDao.removeProperty(commitId, key, value);
    }

    @Nonnull
    public Page<IndexedChangeset> search(@Nonnull IndexSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)searchRequest, (Object)"searchRequest");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        return PageUtils.asPageOf(IndexedChangeset.class, (Page)this.changesetDao.search(searchRequest, pageRequest));
    }

    private static boolean isPersonalFork(Repository repository) {
        return repository.isFork() && repository.getProject().getType() == ProjectType.PERSONAL;
    }

    private IndexedCommit transformForPermissions(final InternalIndexedChangeset changeset) {
        final Set repositories = Chainable.chain((Iterable)changeset.getRepositories()).filter(this.canReadRepositoryPredicate).toSet();
        return new IndexedCommit(){

            @Nonnull
            public String getId() {
                return changeset.getId();
            }

            @Nonnull
            public Date getAuthorTimestamp() {
                return changeset.getAuthorTimestamp();
            }

            @Nonnull
            public Set<Repository> getRepositories() {
                return repositories;
            }
        };
    }
}

