/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.stash.commit.graph.TraversalCallback;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.commit.graph.cache.CachedCommitGraphOutputStream;
import com.atlassian.stash.internal.commit.graph.cache.PersistingTraversalCallback;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.util.contentcache.ContentProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class TraversalScmContentProvider
implements ContentProvider {
    private final ScmService scmService;
    private final Repository repository;
    private final I18nService i18nService;

    public TraversalScmContentProvider(ScmService scmService, Repository repository, I18nService i18nService) {
        Preconditions.checkNotNull((Object)scmService, (Object)"scmService");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)i18nService, (Object)"i18nService");
        this.scmService = scmService;
        this.repository = repository;
        this.i18nService = i18nService;
    }

    public void apply(OutputStream out) throws IOException {
        try {
            this.scmService.getCommandFactory(this.repository).traverseCommits((TraversalCallback)new PersistingTraversalCallback(out, this.i18nService)).call();
        }
        catch (ServerException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), CachedCommitGraphOutputStream.CachedCommitGraphOutputStreamIOException.class);
            throw e;
        }
    }

    public Date getExpiry() {
        return null;
    }
}

