/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.commit.graph.CommitGraphContext;
import com.atlassian.stash.commit.graph.CommitGraphNode;
import com.atlassian.stash.commit.graph.SubgraphTraversalCallback;
import com.atlassian.stash.commit.graph.TraversalCallback;
import com.atlassian.stash.commit.graph.TraversalContext;
import com.atlassian.stash.commit.graph.TraversalRequest;
import com.atlassian.stash.commit.graph.TraversalStatus;
import com.atlassian.stash.commit.graph.TraversalSummary;
import com.atlassian.stash.concurrent.ConcurrencyService;
import com.atlassian.stash.concurrent.VersionTracker;
import com.atlassian.stash.event.RepositoryRefsChangedEvent;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.commit.graph.CachedCommitGraphSource;
import com.atlassian.stash.internal.commit.graph.cache.AbstractCacheTraversalJob;
import com.atlassian.stash.internal.commit.graph.cache.CachedCommitGraphOutputStream;
import com.atlassian.stash.internal.commit.graph.cache.CachedCommitGraphUtils;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.RefChangeType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.UncheckedOperation;
import com.atlassian.stash.util.concurrent.ExecutorUtils;
import com.atlassian.util.contentcache.BackgroundThreadStreamPumper;
import com.atlassian.util.contentcache.CacheAccess;
import com.atlassian.util.contentcache.CacheEntryStatistics;
import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.CacheResult;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.ContentProvider;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.TtlCacheExpiryStrategy;
import com.atlassian.util.contentcache.internal.FileContentCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.spring.context.SpringAware;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultCachedCommitGraphSource
extends AbstractSmartLifecycle
implements CachedCommitGraphSource {
    private static final Logger log = LoggerFactory.getLogger(DefaultCachedCommitGraphSource.class);
    private static final String CACHE_PATH = "commit-graph";
    private static final String CACHE_KEY = "commit-graph";
    private static final String PUMPER_KEY = "commit-graph-pumper";
    private static final int MAX_RETRIES = 5;
    private final ContentCache contentCache;
    private final ScmService scmService;
    private final I18nService i18nService;
    private final ExecutorService executorService;
    private final VersionTracker<Integer> repoVersionTracker;
    private final long maxTraverseWaitTime;
    private final IExecutorService clusterExecutorService;
    private final Queue<Runnable> delayedJobs;
    private final StreamPumper contentCachePump;

    public DefaultCachedCommitGraphSource(ApplicationSettings applicationSettings, ScmService scmService, I18nService i18nService, ConcurrencyService concurrencyService, ExecutorService executorService, IExecutorService clusterExecutorService, long requiredFreeSpace, long maxTraverseWaitTime) {
        this.clusterExecutorService = clusterExecutorService;
        this.contentCachePump = new BackgroundThreadStreamPumper(PUMPER_KEY);
        this.contentCache = this.createFileCache(new File(applicationSettings.getCacheDir(), "commit-graph"), requiredFreeSpace);
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.maxTraverseWaitTime = maxTraverseWaitTime;
        this.repoVersionTracker = concurrencyService.getVersionTracker(this.getClass().getName() + ".repoVersionTracker");
        this.scmService = scmService;
        this.delayedJobs = new LinkedList<Runnable>();
    }

    public int getPhase() {
        return 1002;
    }

    @EventListener
    public void onRepositoryRefChanges(RepositoryRefsChangedEvent event) throws Exception {
        if (!this.isRunning()) {
            return;
        }
        Repository repository = event.getRepository();
        boolean hasRefChanges = !event.getRefChanges().isEmpty();
        boolean onlyDeletions = Iterables.all((Iterable)event.getRefChanges(), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)RefChangeType.DELETE), (Function)RefChange.TO_TYPE));
        boolean isFork = repository.isFork();
        log.debug("Checking RepositoryRefsChangedEvent for ref changes on [{0}]; has changes: {1}, is fork: {2}, only deletions {3}", new Object[]{repository, hasRefChanges, isFork, onlyDeletions});
        if (hasRefChanges && !onlyDeletions) {
            this.repoVersionTracker.increment((Serializable)repository.getId());
            if (!isFork) {
                this.clusterExecutorService.executeOnAllMembers((Runnable)new RebuildCacheTask(repository.getId()));
            }
        }
    }

    @Override
    public void purgeStaleEntries() {
        for (CacheEntryStatistics entryStats : this.contentCache.getStatistics().getEntries()) {
            int repoId;
            int currentRepoVersion;
            int version;
            String entryKey = entryStats.getKey();
            int[] repoIdAndVersion = this.toRepoIdAndVersion(entryKey);
            if (repoIdAndVersion == null || (version = repoIdAndVersion[1]) == (currentRepoVersion = this.repoVersionTracker.get((Serializable)Integer.valueOf(repoId = repoIdAndVersion[0])))) continue;
            this.contentCache.remove(this.getCacheKey(repoId, version));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildFor(Repository repository) {
        RetryingCacheTraversalJob cacheTraversalJob = new RetryingCacheTraversalJob(repository, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        if (!this.isRunning()) {
            Queue<Runnable> queue = this.delayedJobs;
            synchronized (queue) {
                if (!this.isRunning()) {
                    this.delayedJobs.offer(cacheTraversalJob);
                    return;
                }
            }
        }
        this.executorService.execute(cacheTraversalJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        super.start();
        Queue<Runnable> queue = this.delayedJobs;
        synchronized (queue) {
            Iterator it = this.delayedJobs.iterator();
            while (it.hasNext()) {
                this.executorService.execute((Runnable)it.next());
                it.remove();
            }
        }
    }

    public void stop() {
        this.contentCache.clear();
        this.contentCachePump.shutdown();
        ExecutorUtils.shutdown((ExecutorService)this.executorService, (Logger)log);
        super.stop();
    }

    @Override
    public void traverse(@Nonnull TraversalRequest request, @Nonnull TraversalCallback callback) {
        block23: {
            Preconditions.checkNotNull((Object)request, (Object)"request");
            Preconditions.checkNotNull((Object)callback, (Object)"callback");
            if (!this.isRunning()) {
                return;
            }
            Repository repository = request.getRepository();
            CommitGraphContext commitGraphContext = new CommitGraphContext.Builder().exclude((Iterable)request.getExcludes()).include((Iterable)request.getIncludes()).build();
            DelegatingCompletionWaitingTraversalCallback futureCallback = new DelegatingCompletionWaitingTraversalCallback((TraversalCallback)new SubgraphTraversalCallback(callback, commitGraphContext));
            CachedCommitGraphOutputStream cachedCommitGraphOutputStream = new CachedCommitGraphOutputStream(futureCallback);
            String cacheKey = this.getCacheKey(repository);
            ContentProvider contentProvider = CachedCommitGraphUtils.getTimedScmContentProvider(repository, this.scmService, this.i18nService);
            try (Timer timer = TimerUtils.start((String)(repository.getId() + ": reading traversal index"));){
                CacheAccess cacheAccess = this.contentCache.access(cacheKey, (OutputStream)cachedCommitGraphOutputStream, contentProvider);
                CacheResult cacheResult = cacheAccess.getResult();
                if (cacheResult == CacheResult.MISS) {
                    log.debug("{} during traversal for {}, delegating job to executorService", (Object)cacheResult, (Object)repository);
                    SingleCacheTraversalJob job = new SingleCacheTraversalJob(repository, cachedCommitGraphOutputStream, cacheAccess);
                    this.executorService.execute(job);
                    try {
                        futureCallback.await(this.maxTraverseWaitTime, TimeUnit.SECONDS);
                        break block23;
                    }
                    catch (InterruptedException e) {
                        throw new ServerException(this.i18nService.createKeyedMessage("stash.commit.graph.traversal.read.interruptedexception", new Object[]{repository}), (Throwable)e);
                    }
                }
                log.debug("{} during traversal for {}", (Object)cacheResult, (Object)repository);
                try {
                    cacheAccess.stream();
                }
                catch (CachedCommitGraphOutputStream.CachedCommitGraphOutputStreamIOException e) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                throw new ServerException(this.i18nService.createKeyedMessage("stash.commit.graph.traversal.read.ioexception", new Object[]{repository}), (Throwable)e);
            }
            finally {
                Closeables.closeQuietly((Closeable)cachedCommitGraphOutputStream);
            }
        }
    }

    @VisibleForTesting
    protected ContentCache createFileCache(File directory, long requiredFreeSpace) {
        return new FileContentCache("commit-graph", directory, (CacheExpiryStrategy)new TtlCacheExpiryStrategy(), requiredFreeSpace, this.contentCachePump);
    }

    private String getCacheKey(Repository repository) {
        return this.getCacheKey(repository.getId(), this.repoVersionTracker.get((Serializable)repository.getId()));
    }

    private String getCacheKey(int repositoryId, int version) {
        return Integer.toString(version) + "/" + Integer.toString(repositoryId);
    }

    private int[] toRepoIdAndVersion(String cacheKey) {
        String[] segments = cacheKey.split("/");
        if (segments.length == 2) {
            try {
                return new int[]{Integer.parseInt(segments[1]), Integer.parseInt(segments[0])};
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @SpringAware
    static class RebuildCacheTask
    implements Runnable,
    Serializable {
        @Autowired
        transient RepositoryService repositoryService;
        @Autowired
        transient CachedCommitGraphSource cache;
        @Autowired
        transient SecurityService securityservice;
        private final int repoId;

        public RebuildCacheTask(int repoId) {
            this.repoId = repoId;
        }

        @Override
        public void run() {
            Repository repository = (Repository)this.securityservice.withPermission(Permission.ADMIN, "Looking up repository to invalidate its commit graph cache").call((Operation)new UncheckedOperation<Repository>(){

                public Repository perform() {
                    return RebuildCacheTask.this.repositoryService.getById(RebuildCacheTask.this.repoId);
                }
            });
            if (repository != null) {
                this.cache.rebuildFor(repository);
            }
        }
    }

    class SingleCacheTraversalJob
    extends AbstractCacheTraversalJob {
        private static final int PRIORITY = 2;
        private final CacheAccess cacheAccess;

        public SingleCacheTraversalJob(Repository repository, OutputStream outputStream, CacheAccess cacheAccess) {
            super(2, repository, outputStream);
            this.cacheAccess = cacheAccess;
        }

        @Override
        public void run() {
            try {
                this.cacheAccess.stream();
            }
            catch (CachedCommitGraphOutputStream.CachedCommitGraphOutputStreamIOException e) {
            }
            catch (IOException e) {
                DefaultCachedCommitGraphSource.this.rebuildFor(this.repository);
                throw new ServerException(DefaultCachedCommitGraphSource.this.i18nService.createKeyedMessage("stash.commit.graph.traversal.read.ioexception", new Object[]{this.repository}), (Throwable)e);
            }
        }
    }

    class RetryingCacheTraversalJob
    extends AbstractCacheTraversalJob {
        private static final int PRIORITY = 1;
        private final OutputStream outputStream;
        private final int maxRetries;
        private int retries;

        public RetryingCacheTraversalJob(Repository repository, OutputStream outputStream) {
            super(1, repository, outputStream);
            this.outputStream = outputStream;
            this.maxRetries = 5;
            this.retries = 0;
        }

        @Override
        public void run() {
            if (!DefaultCachedCommitGraphSource.this.isRunning()) {
                return;
            }
            try {
                this.streamCache();
            }
            catch (Exception e) {
                if (this.retries < this.maxRetries) {
                    ++this.retries;
                    DefaultCachedCommitGraphSource.this.executorService.execute(this);
                }
                log.warn("Failed to stream commit graph on {} after {} retries", new Object[]{this.repository.toString(), this.maxRetries, e});
            }
        }

        private void streamCache() throws IOException {
            String cacheKey = DefaultCachedCommitGraphSource.this.getCacheKey(this.repository);
            ContentProvider contentProvider = CachedCommitGraphUtils.getTimedScmContentProvider(this.repository, DefaultCachedCommitGraphSource.this.scmService, DefaultCachedCommitGraphSource.this.i18nService);
            DefaultCachedCommitGraphSource.this.contentCache.remove(cacheKey);
            CacheAccess cacheAccess = DefaultCachedCommitGraphSource.this.contentCache.access(cacheKey, this.outputStream, contentProvider);
            if (cacheAccess.getResult() == CacheResult.MISS) {
                cacheAccess.stream();
            } else {
                cacheAccess.cancel();
            }
        }
    }

    class DelegatingCompletionWaitingTraversalCallback
    extends TraversalCallback {
        private final TraversalCallback delegate;
        private final CountDownLatch countDownLatch;
        private volatile boolean finished;

        public DelegatingCompletionWaitingTraversalCallback(TraversalCallback delegate) {
            this.delegate = delegate;
            this.countDownLatch = new CountDownLatch(1);
            this.finished = false;
        }

        public void await() throws InterruptedException {
            this.countDownLatch.await();
        }

        public void await(long timeout, TimeUnit unit) throws InterruptedException {
            this.countDownLatch.await(timeout, unit);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void onEnd(@Nonnull TraversalSummary summary) {
            this.delegate.onEnd(summary);
            this.finished = true;
            this.countDownLatch.countDown();
        }

        public TraversalStatus onNode(@Nonnull CommitGraphNode node) {
            return this.delegate.onNode(node);
        }

        public void onStart(@Nonnull TraversalContext context) {
            this.delegate.onStart(context);
        }
    }
}

