/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.commit.Commit;
import com.atlassian.stash.commit.SimpleCommit;
import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.InternalChangeset;
import com.atlassian.stash.idx.ChangesetAttributeConfiguration;
import com.atlassian.stash.idx.CommitIndex;
import com.atlassian.stash.idx.CommitPropertyConfiguration;
import com.atlassian.stash.internal.idx.DbChangesetIndex;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Person;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PredicateUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=com.atlassian.stash.commit.CommitEnricher.class)
@Component(value="commitEnricher")
@Transactional(readOnly=true)
public class DatabaseCommitEnricher
implements com.atlassian.stash.commit.CommitEnricher {
    private final RepositoryActivityDao activityDao;
    private final ChangesetAttributeConfiguration attributeConfiguration;
    private final StashAuthenticationContext authenticationContext;
    private final CommitPropertyConfiguration configuration;
    private final InternalUserService userService;
    @Autowired
    private final CommitIndex index = null;

    @Autowired
    public DatabaseCommitEnricher(RepositoryActivityDao activityDao, StashAuthenticationContext authenticationContext, CommitPropertyConfiguration propertyConfiguration, ChangesetAttributeConfiguration attributeConfiguration, InternalUserService userService) {
        this.activityDao = activityDao;
        this.authenticationContext = authenticationContext;
        this.configuration = propertyConfiguration;
        this.attributeConfiguration = attributeConfiguration;
        this.userService = userService;
    }

    @Nonnull
    public Changeset enrich(@Nonnull Repository repository, @Nonnull Changeset commit, Collection<String> propertyKeys) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)commit, (Object)"commit");
        return (Changeset)this.createLegacyEnricher(repository, Collections.singleton(commit), propertyKeys).apply((Object)commit);
    }

    @Nonnull
    public Commit enrich(@Nonnull Repository repository, @Nonnull Commit commit, Collection<String> propertyKeys) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)commit, (Object)"commit");
        return (Commit)this.createEnricher(repository, Collections.singleton(commit), propertyKeys).apply((Object)commit);
    }

    @Nonnull
    public Iterable<Changeset> enrich(@Nonnull Repository repository, @Nonnull Iterable<Changeset> commits, Collection<String> propertyKeys) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(commits, (Object)"commits");
        return Iterables.transform(commits, this.createLegacyEnricher(repository, commits, propertyKeys));
    }

    @Nonnull
    public Page<Changeset> enrich(@Nonnull Repository repository, @Nonnull Page<Changeset> page, Collection<String> propertyKeys) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(page, (Object)"page");
        return page.transform(this.createLegacyEnricher(repository, page.getValues(), propertyKeys));
    }

    @Nonnull
    public Iterable<Commit> enrichAll(@Nonnull Repository repository, @Nonnull Iterable<Commit> commits, Collection<String> propertyKeys) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(commits, (Object)"commits");
        return Iterables.transform(commits, this.createEnricher(repository, commits, propertyKeys));
    }

    @Nonnull
    public Page<Commit> enrichPage(@Nonnull Repository repository, @Nonnull Page<Commit> page, Collection<String> propertyKeys) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(page, (Object)"page");
        return page.transform(this.createEnricher(repository, page.getValues(), propertyKeys));
    }

    private Function<Commit, Commit> createEnricher(Repository repository, Iterable<Commit> commits, Collection<String> propertyKeys) {
        Set<String> commitIds = this.toIds(commits, Commit.TO_ID);
        Map propertiesByCommit = this.index.getProperties(commitIds, this.getPropertiesToLoad(repository, propertyKeys));
        Map<String, Long> commentsByCommit = this.mapCommentsByCommit(repository.getId(), commitIds);
        Map<String, StashUser> usersByEmail = this.mapUsersByEmail(commits, Commit.TO_AUTHOR);
        if (propertiesByCommit.isEmpty() && usersByEmail.isEmpty() && commentsByCommit.isEmpty()) {
            return Functions.identity();
        }
        return new CommitEnricher(propertiesByCommit, commentsByCommit, usersByEmail);
    }

    private Function<Changeset, Changeset> createLegacyEnricher(Repository repository, Iterable<Changeset> commits, Collection<String> propertyKeys) {
        Set<String> commitIds = this.toIds(commits, Changeset.TO_ID);
        Map propertiesByCommit = this.index.getProperties(commitIds, this.getPropertiesToLoad(repository, propertyKeys));
        Map<String, Long> commentsByCommit = this.mapCommentsByCommit(repository.getId(), commitIds);
        Map<String, StashUser> usersByEmail = this.mapUsersByEmail(commits, Changeset.TO_AUTHOR);
        if (propertiesByCommit.isEmpty() && usersByEmail.isEmpty() && commentsByCommit.isEmpty()) {
            return Functions.identity();
        }
        return new ChangesetEnricher(propertiesByCommit, commentsByCommit, usersByEmail);
    }

    @Nonnull
    private Set<String> getPropertiesToLoad(Repository repository, Collection<String> propertiesRequested) {
        ImmutableSet.Builder builder = ImmutableSet.builder().addAll((Iterable)this.attributeConfiguration.getAttributesToPreload(repository)).addAll((Iterable)this.configuration.getPropertiesToPreload(repository));
        if (propertiesRequested != null) {
            builder.addAll(propertiesRequested);
        }
        return builder.build();
    }

    private Map<String, Long> mapCommentsByCommit(int repositoryId, Set<String> commitIds) {
        if (this.authenticationContext.isAuthenticated()) {
            return this.activityDao.countCommentsByCommit(repositoryId, commitIds);
        }
        return Collections.emptyMap();
    }

    private <T> Map<String, StashUser> mapUsersByEmail(Iterable<T> commits, Function<? super T, Person> toAuthor) {
        Set emailAddresses = Chainable.chain(commits).transform(toAuthor).transform(Person.TO_EMAIL_ADDRESS).filter(PredicateUtils.notBlank()).toSet();
        return this.userService.mapUsersByEmail(emailAddresses);
    }

    private <T> Set<String> toIds(Iterable<T> commits, Function<? super T, String> toId) {
        return Chainable.chain(commits).transform(toId).toSet();
    }

    private static class CommitEnricher
    implements Function<Commit, Commit> {
        private final Map<String, PropertyMap> propertiesByCommit;
        private final Map<String, Long> commentsByCommit;
        private final Map<String, StashUser> usersByEmail;

        private CommitEnricher(Map<String, PropertyMap> propertiesByCommit, Map<String, Long> commentsByCommit, Map<String, StashUser> usersByEmail) {
            this.propertiesByCommit = propertiesByCommit;
            this.commentsByCommit = commentsByCommit;
            this.usersByEmail = usersByEmail;
        }

        public Commit apply(Commit commit) {
            Long comments;
            PropertyMap properties;
            SimpleCommit.Builder builder = null;
            StashUser user = this.usersByEmail.get(commit.getAuthor().getEmailAddress());
            if (user != null) {
                builder = new SimpleCommit.Builder(commit).author((Person)user);
            }
            if ((properties = this.propertiesByCommit.get(commit.getId())) != null) {
                if (builder == null) {
                    builder = new SimpleCommit.Builder(commit);
                }
                builder.properties((Map)properties);
                builder.attributes((AttributeMap)DbChangesetIndex.PROPERTIES_TO_ATTRIBUTES.apply((Object)properties));
            }
            if ((comments = this.commentsByCommit.get(commit.getId())) != null) {
                if (builder == null) {
                    builder = new SimpleCommit.Builder(commit);
                }
                builder.attribute("commentCount", comments.toString());
                builder.property("commentCount", (Object)comments);
            }
            return builder == null ? commit : builder.build();
        }
    }

    private static class ChangesetEnricher
    implements Function<Changeset, Changeset> {
        private final Map<String, PropertyMap> propertiesByCommit;
        private final Map<String, Long> commentsByCommit;
        private final Map<String, StashUser> usersByEmail;

        private ChangesetEnricher(Map<String, PropertyMap> propertiesByCommit, Map<String, Long> commentsByCommit, Map<String, StashUser> usersByEmail) {
            this.propertiesByCommit = propertiesByCommit;
            this.commentsByCommit = commentsByCommit;
            this.usersByEmail = usersByEmail;
        }

        public Changeset apply(Changeset commit) {
            Long comments;
            PropertyMap properties;
            InternalChangeset.Builder builder = null;
            StashUser user = this.usersByEmail.get(commit.getAuthor().getEmailAddress());
            if (user != null) {
                builder = new InternalChangeset.Builder(commit).author((Person)user);
            }
            if ((properties = this.propertiesByCommit.get(commit.getId())) != null) {
                if (builder == null) {
                    builder = new InternalChangeset.Builder(commit);
                }
                builder.properties((Map)properties);
                builder.attributes((AttributeMap)DbChangesetIndex.PROPERTIES_TO_ATTRIBUTES.apply((Object)properties));
            }
            if ((comments = this.commentsByCommit.get(commit.getId())) != null) {
                if (builder == null) {
                    builder = new InternalChangeset.Builder(commit);
                }
                builder.attribute("commentCount", comments.toString());
                builder.property("commentCount", (Object)comments);
            }
            return builder == null ? commit : builder.build();
        }
    }
}

