/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.cluster.ClusterJoinCheck;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckAction;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckResult;
import com.atlassian.stash.internal.cluster.ClusterJoinManager;
import com.atlassian.stash.internal.cluster.ClusterJoinMode;
import com.atlassian.stash.internal.cluster.ClusterJoinRequest;
import com.atlassian.stash.internal.cluster.HazelcastDataUtils;
import com.atlassian.stash.internal.cluster.NodeConnectionException;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.johnson.JohnsonUtils;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.OrderComparator;
import org.springframework.stereotype.Component;

@Component(value="clusterJoinManager")
@Profiled
public class DefaultClusterJoinManager
implements ClusterJoinManager {
    private static final Function<String, String> HTML_ESCAPE = new Function<String, String>(){

        public String apply(String value) {
            return StringEscapeUtils.escapeHtml((String)value);
        }
    };
    private final Clock clock;
    private final Map<String, ClusterJoinCheck> joinChecks;
    private final LicenseHelper licenseHelper;
    private final ServletContext servletContext;
    private final long startTime;

    @Autowired
    public DefaultClusterJoinManager(Clock clock, LicenseHelper licenseHelper, ServletContext servletContext, ClusterJoinCheck ... joinChecks) {
        this.clock = clock;
        this.joinChecks = new LinkedHashMap<String, ClusterJoinCheck>(joinChecks.length);
        this.licenseHelper = licenseHelper;
        this.servletContext = servletContext;
        this.startTime = clock.nanoTime();
        ArrayList orderedChecks = Lists.newArrayList((Object[])joinChecks);
        Collections.sort(orderedChecks, new OrderComparator());
        for (ClusterJoinCheck joinCheck : joinChecks) {
            this.joinChecks.put(joinCheck.getName(), joinCheck);
        }
    }

    @Override
    public void accept(@Nonnull ClusterJoinRequest request) throws IOException {
        Preconditions.checkArgument((((ClusterJoinRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getJoinMode() == ClusterJoinMode.ACCEPT ? 1 : 0) != 0, (Object)"Expected accept request");
        this.checkAcceptingClusterConnections();
        request.out().writeInt(this.joinChecks.size());
        for (ClusterJoinCheck joinCheck : this.joinChecks.values()) {
            Timer timer = TimerUtils.start((String)("join check " + joinCheck.getName()));
            Throwable throwable = null;
            try {
                request.out().writeUTF(joinCheck.getName());
                ClusterJoinCheckResult outcome = request.in().readBoolean() ? joinCheck.accept(request) : joinCheck.onUnknown(request);
                this.negotiateOutcome(outcome, request);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (timer == null) continue;
                if (throwable != null) {
                    try {
                        timer.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                timer.close();
            }
        }
        this.negotiateOutcome(ClusterJoinCheckResult.OK, request);
    }

    @Override
    public void connect(@Nonnull ClusterJoinRequest request) throws IOException {
        Preconditions.checkArgument((((ClusterJoinRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getJoinMode() == ClusterJoinMode.CONNECT ? 1 : 0) != 0, (Object)"Expected connect request");
        this.checkAcceptingClusterConnections();
        HashSet<String> toBeChecked = new HashSet<String>(this.joinChecks.keySet());
        int numberOfChecks = request.in().readInt();
        for (int i = 0; i < numberOfChecks; ++i) {
            String checkName = request.in().readUTF();
            try (Timer timer = TimerUtils.start((String)("join check - " + checkName));){
                ClusterJoinCheckResult outcome;
                if (toBeChecked.remove(checkName)) {
                    request.out().writeBoolean(true);
                    outcome = this.joinChecks.get(checkName).connect(request);
                } else {
                    request.out().writeBoolean(false);
                    outcome = ClusterJoinCheckResult.OK;
                }
                this.negotiateOutcome(outcome, request);
                continue;
            }
        }
        for (String checkName : toBeChecked) {
            ClusterJoinCheckResult outcome = this.joinChecks.get(checkName).onUnknown(request);
            if (outcome.getAction() == ClusterJoinCheckAction.CONNECT) continue;
            this.negotiateOutcome(outcome, request);
        }
        this.negotiateOutcome(ClusterJoinCheckResult.OK, request);
    }

    private void checkAcceptingClusterConnections() throws IOException {
        if (this.isSystemUnavailable()) {
            throw new NodeConnectionException("Not accepting cluster connections at the moment");
        }
        if (!this.licenseHelper.isClusteringEnabled(false)) {
            throw new NodeConnectionException("Clustering is not enabled");
        }
    }

    private JohnsonEventContainer getEventContainer() {
        return Johnson.getEventContainer((ServletContext)this.servletContext);
    }

    private long getUptimeNanos() {
        return this.clock.nanoTime() - this.startTime;
    }

    private boolean isSystemUnavailable() {
        String highestLevel = JohnsonUtils.findHighestEventLevel((JohnsonEventContainer)this.getEventContainer());
        return highestLevel != null && JohnsonUtils.isLevelAtLeast((String)highestLevel, (String)"error");
    }

    private void negotiateOutcome(ClusterJoinCheckResult result, ClusterJoinRequest request) throws IOException {
        ClusterJoinCheckAction resolvedAction;
        ClusterJoinCheckAction remoteAction;
        ClusterJoinCheckAction localAction = result.getAction();
        request.out().writeInt(result.getAction().getId());
        if (localAction != ClusterJoinCheckAction.CONNECT) {
            HazelcastDataUtils.writeList(request.out(), result.getMessages());
        }
        if ((remoteAction = ClusterJoinCheckAction.forId(request.in().readInt())) == ClusterJoinCheckAction.CONNECT && localAction == ClusterJoinCheckAction.CONNECT) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>((Collection<String>)result.getMessages());
        if (remoteAction != ClusterJoinCheckAction.CONNECT) {
            errors.addAll(HazelcastDataUtils.readList(request.in()));
        }
        if ((resolvedAction = this.resolveAction(localAction, remoteAction)) == ClusterJoinCheckAction.PASSIVATE_ANY_NODE) {
            int clusterSize = request.getHazelcast().getCluster().getMembers().size();
            long uptime = this.getUptimeNanos();
            request.out().writeInt(clusterSize);
            request.out().writeLong(uptime);
            long remoteClusterSize = request.in().readInt();
            long remoteUptime = request.in().readLong();
            if (remoteClusterSize > (long)clusterSize) {
                this.passivateNode(errors);
            } else if (remoteClusterSize == (long)clusterSize && (remoteUptime > uptime || remoteUptime == uptime && request.getJoinMode() == ClusterJoinMode.CONNECT)) {
                this.passivateNode(errors);
            }
        } else if (resolvedAction == ClusterJoinCheckAction.PASSIVATE_THIS_NODE) {
            this.passivateNode(errors);
        }
        throw new NodeConnectionException(errors);
    }

    private void passivateNode(List<String> issues) {
        String error = "The current node is unable to safely connect to the cluster and will not service requests<ul><li>" + StringUtils.join((Collection)Collections2.transform(issues, HTML_ESCAPE), (String)"</li><li>") + "</li></ul>";
        this.getEventContainer().addEvent(new Event(EventType.get((String)"node-passivated"), error, EventLevel.get((String)"error")));
    }

    private ClusterJoinCheckAction resolveAction(ClusterJoinCheckAction localAction, ClusterJoinCheckAction remoteAction) {
        switch (remoteAction) {
            case CONNECT: {
                return localAction;
            }
            case DISCONNECT: 
            case PASSIVATE_ANY_NODE: {
                return localAction.isPassivate() ? localAction : remoteAction;
            }
            case PASSIVATE_OTHER_NODE: {
                return localAction == ClusterJoinCheckAction.PASSIVATE_OTHER_NODE ? ClusterJoinCheckAction.PASSIVATE_ANY_NODE : ClusterJoinCheckAction.PASSIVATE_THIS_NODE;
            }
            case PASSIVATE_THIS_NODE: {
                return localAction == ClusterJoinCheckAction.PASSIVATE_THIS_NODE ? ClusterJoinCheckAction.PASSIVATE_ANY_NODE : ClusterJoinCheckAction.PASSIVATE_OTHER_NODE;
            }
        }
        throw new IllegalArgumentException("Unsupported ClusterJoinAction " + (Object)((Object)remoteAction));
    }
}

