/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.stash.auth.HttpAuthenticationContext;
import com.atlassian.stash.auth.HttpAuthenticationHandler;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.RememberMeServices;

public class RememberMeAuthenticationHandler
implements HttpAuthenticationHandler {
    private final RememberMeServices rememberMeServices;
    private final UserService userService;

    public RememberMeAuthenticationHandler(RememberMeServices rememberMeServices, UserService userService) {
        this.rememberMeServices = rememberMeServices;
        this.userService = userService;
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext context) {
    }

    @Nullable
    public StashUser authenticate(@Nonnull HttpAuthenticationContext context) {
        Authentication auth = this.rememberMeServices.autoLogin(context.getRequest(), context.getResponse());
        if (auth != null) {
            return this.userService.getUserByName(auth.getName());
        }
        return null;
    }
}

