/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.stash.auth.HttpAuthenticationSuccessContext;
import com.atlassian.stash.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.stash.internal.config.Feature;
import com.atlassian.stash.internal.config.FeatureManager;
import com.atlassian.stash.internal.user.InternalUserSettingsService;
import com.atlassian.stash.nav.NavBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;

public class RedirectingAuthenticationSuccessHandler
implements HttpAuthenticationSuccessHandler {
    private static final String KEY_NEXT_URL = "next";
    private static final Map<String, Integer> DEFAULT_PORTS = ImmutableMap.builder().put((Object)"http", (Object)80).put((Object)"https", (Object)443).build();
    private final NavBuilder navBuilder;
    private final InternalUserSettingsService userSettingsService;
    private final FeatureManager featureManager;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private final RequestCache requestCache = new HttpSessionRequestCache();

    public RedirectingAuthenticationSuccessHandler(@Nonnull NavBuilder navBuilder, @Nonnull InternalUserSettingsService userSettingsService, @Nonnull FeatureManager featureManager) {
        this.navBuilder = navBuilder;
        this.userSettingsService = userSettingsService;
        this.featureManager = featureManager;
    }

    public boolean onAuthenticationSuccess(@Nonnull HttpAuthenticationSuccessContext context) throws ServletException, IOException {
        if (!"form".equals(context.getMethod())) {
            return false;
        }
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        String nextUrl = this.getRedirectUrl(request);
        if (StringUtils.isNotBlank((String)nextUrl)) {
            if (savedRequest != null) {
                this.requestCache.removeRequest(request, response);
            }
        } else if (savedRequest != null) {
            nextUrl = RedirectingAuthenticationSuccessHandler.stripServletPath(savedRequest.getRedirectUrl(), this.navBuilder.buildAbsolute());
        } else if (nextUrl == null) {
            nextUrl = this.navBuilder.buildAbsolute();
        }
        if (this.featureManager.isEnabled(Feature.GETTING_STARTED)) {
            nextUrl = this.injectGettingStarted(context, nextUrl);
        }
        this.redirectSafely(request, response, nextUrl);
        return true;
    }

    protected String getCanonicalUrl(String url) throws URISyntaxException {
        URI uri = new URI(url);
        StringBuilder builder = new StringBuilder().append(StringUtils.lowerCase((String)uri.getScheme())).append("://").append(uri.getHost());
        if (this.hasCustomPort(uri)) {
            builder.append(":").append(uri.getPort());
        }
        builder.append(uri.getPath());
        return builder.toString();
    }

    protected String getRedirectUrl(HttpServletRequest request) {
        return request.getParameter(KEY_NEXT_URL);
    }

    protected boolean hasCustomPort(URI uri) {
        if (uri.getPort() < 0) {
            return false;
        }
        Integer defaultPort = DEFAULT_PORTS.get(uri.getScheme());
        return defaultPort == null || defaultPort.intValue() != uri.getPort();
    }

    protected void redirectSafely(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        response.setHeader("Cache-Control", "private, max-age=0, no-cache");
        response.setDateHeader("Expires", 0L);
        this.redirectStrategy.sendRedirect(request, response, this.safeUrl(url, this.navBuilder.buildAbsolute()));
    }

    private String contextRelative(String nextUrl) {
        String contextPath = this.navBuilder.buildRelative();
        return nextUrl.startsWith(contextPath) ? nextUrl : contextPath + nextUrl;
    }

    private String injectGettingStarted(HttpAuthenticationSuccessContext context, String nextUrl) {
        UserSettings userSettings = this.userSettingsService.getUserSettings(context.getUser());
        if (userSettings != null && ((Boolean)userSettings.getBoolean("SHOW_GETTING_STARTED_PAGE").getOrElse((Object)false)).booleanValue()) {
            String redirectUrl = this.contextRelative(URIUtil.getPathQuery((String)nextUrl));
            nextUrl = this.navBuilder.gettingStarted().next(redirectUrl).buildRelNoContext();
        }
        return nextUrl;
    }

    private boolean isLocalPath(URI uri) {
        return StringUtils.isNotEmpty((String)uri.getPath()) && uri.getAuthority() == null && uri.getHost() == null && uri.getPort() == -1 && uri.getScheme() == null;
    }

    private String safeUrl(String url, String fallbackUrl) {
        try {
            URI uri = new URI(url);
            if (this.isLocalPath(uri)) {
                return url.charAt(0) == '/' ? url : '/' + url;
            }
            String baseUrl = this.getCanonicalUrl(this.navBuilder.buildAbsolute() + "/");
            String redirectUrl = this.getCanonicalUrl(url);
            if (redirectUrl.startsWith(baseUrl)) {
                return url;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return fallbackUrl;
    }

    @VisibleForTesting
    static String stripServletPath(String url, String prefix) {
        String mvc = "/mvc/";
        if (url.startsWith(prefix + mvc)) {
            url = prefix + "/" + url.substring(prefix.length() + mvc.length());
        }
        return url;
    }
}

