/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit.external;

import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.Event;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.audit.AuditEntry;
import com.atlassian.stash.audit.Priority;
import com.atlassian.stash.internal.audit.AbstractAuditEventPublisher;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrowdEventListener
extends AbstractAuditEventPublisher {
    @Autowired
    public CrowdEventListener(AuditEntryLoggingService auditLoggingService, RequestManager requestManager, StashAuthenticationContext authContext, EventPublisher eventPublisher) {
        super(auditLoggingService, requestManager, authContext, eventPublisher);
    }

    @EventListener
    public void onDirectoryCreated(DirectoryCreatedEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getDirectory().getName()).build();
        this.publish(event, auditEntry, Priority.HIGH);
    }

    @EventListener
    public void onDirectoryDeleted(DirectoryDeletedEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getDirectory().getName()).build();
        this.publish(event, auditEntry, Priority.HIGH);
    }

    @EventListener
    public void onGroupCreated(GroupCreatedEvent event) throws Exception {
        if (!CrowdEventListener.isForInternalDirectory((DirectoryEvent)event)) {
            return;
        }
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getGroup().getName()).build();
        this.publish(event, auditEntry, CrowdEventListener.getAuditPriority((DirectoryEvent)event));
    }

    @EventListener
    public void onGroupUpdated(GroupUpdatedEvent event) throws Exception {
        if (!CrowdEventListener.isForInternalDirectory((DirectoryEvent)event)) {
            return;
        }
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getGroup().getName()).build();
        this.publish(event, auditEntry, CrowdEventListener.getAuditPriority((DirectoryEvent)event));
    }

    @EventListener
    public void onGroupDeleted(GroupDeletedEvent event) throws Exception {
        if (!CrowdEventListener.isForInternalDirectory((DirectoryEvent)event)) {
            return;
        }
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getGroupName()).build();
        this.publish(event, auditEntry, CrowdEventListener.getAuditPriority((DirectoryEvent)event));
    }

    @EventListener
    public void onGroupMembershipCreated(GroupMembershipCreatedEvent event) throws Exception {
        if (!CrowdEventListener.isForInternalDirectory((DirectoryEvent)event)) {
            return;
        }
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getGroupName()).details(this.convertToJsonString(ImmutableMap.builder().put((Object)"entity", (Object)event.getEntityName()).put((Object)"membership", (Object)event.getMembershipType()).build())).build();
        this.publish(event, auditEntry, CrowdEventListener.getAuditPriority((DirectoryEvent)event));
    }

    @EventListener
    public void onGroupMembershipDeleted(GroupMembershipDeletedEvent event) throws Exception {
        if (!CrowdEventListener.isForInternalDirectory((DirectoryEvent)event)) {
            return;
        }
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getGroupName()).details(this.convertToJsonString(ImmutableMap.builder().put((Object)"entity", (Object)event.getEntityName()).put((Object)"membership", (Object)event.getMembershipType()).build())).build();
        this.publish(event, auditEntry, CrowdEventListener.getAuditPriority((DirectoryEvent)event));
    }

    @EventListener
    public void onUserCreated(UserCreatedEvent event) throws Exception {
        if (!CrowdEventListener.isForInternalDirectory((DirectoryEvent)event)) {
            return;
        }
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getUser().getName()).build();
        this.publish(event, auditEntry, CrowdEventListener.getAuditPriority((DirectoryEvent)event));
    }

    @EventListener
    public void onUserCredentialUpdated(UserCredentialUpdatedEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getUsername()).build();
        this.publish(event, auditEntry, CrowdEventListener.getAuditPriority((DirectoryEvent)event));
    }

    @EventListener
    public void onUserDeleted(UserDeletedEvent event) throws Exception {
        if (!CrowdEventListener.isForInternalDirectory((DirectoryEvent)event)) {
            return;
        }
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getUsername()).build();
        this.publish(event, auditEntry, CrowdEventListener.getAuditPriority((DirectoryEvent)event));
    }

    @EventListener
    public void onUserRenamed(UserRenamedEvent event) throws Exception {
        if (!CrowdEventListener.isForInternalDirectory((DirectoryEvent)event)) {
            return;
        }
        AuditEntry auditEntry = this.createAuditEntryBuilder((Event)event).target(event.getUser().getName()).details(this.convertToJsonString(ImmutableMap.builder().put((Object)"oldUsername", (Object)event.getOldUsername()).build())).build();
        this.publish(event, auditEntry, CrowdEventListener.getAuditPriority((DirectoryEvent)event));
    }

    private static boolean isForInternalDirectory(DirectoryEvent event) {
        return event.getDirectory().getType() == DirectoryType.INTERNAL;
    }

    private static Priority getAuditPriority(DirectoryEvent event) {
        return CrowdEventListener.isForInternalDirectory(event) ? Priority.HIGH : Priority.MEDIUM;
    }

    private AuditEntry.Builder createAuditEntryBuilder(Event event) {
        return this.setCommonFields(event, new AuditEntry.Builder()).timestamp(event.getTimestamp());
    }
}

