/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.internal.user.UserHelper;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.UserUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userHelper")
public class DefaultUserHelper
implements UserHelper {
    private final StashUserDao userDao;

    @Autowired
    public DefaultUserHelper(StashUserDao userDao) {
        this.userDao = userDao;
    }

    @Nonnull
    public InternalNormalUser transform(@Nonnull User user) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        InternalNormalUser loaded = this.userDao.loadUser(user);
        if (loaded == null) {
            loaded = DefaultUserHelper.newStashUser(user);
        }
        return loaded;
    }

    @Nonnull
    public Page<InternalNormalUser> transform(@Nonnull Page<User> page) {
        Preconditions.checkNotNull(page, (Object)"page");
        ImmutableMap stashUsers = Maps.uniqueIndex((Iterable)this.userDao.loadUsers(page.getValues()), (Function)UserUtils.TO_USERNAME);
        return page.transform((Function)new Function<User, InternalNormalUser>((Map)stashUsers){
            final /* synthetic */ Map val$stashUsers;
            {
                this.val$stashUsers = map;
            }

            public InternalNormalUser apply(User user) {
                InternalNormalUser loaded = (InternalNormalUser)this.val$stashUsers.get(UserUtils.TO_USERNAME.apply((Object)user));
                if (loaded == null) {
                    loaded = DefaultUserHelper.newStashUser(user);
                }
                return loaded;
            }
        });
    }

    private static InternalNormalUser newStashUser(@Nonnull User user) {
        return new InternalNormalUser.Builder().crowdUser(user).name(user.getName()).build();
    }
}

