/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.Product;
import com.atlassian.stash.event.user.GroupCleanupEvent;
import com.atlassian.stash.event.user.UserCleanupEvent;
import com.atlassian.stash.exception.ForbiddenException;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.exception.InvalidTokenException;
import com.atlassian.stash.exception.LicenseLimitException;
import com.atlassian.stash.exception.MailException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.NoSuchGroupException;
import com.atlassian.stash.exception.NoSuchUserException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.AbstractVoidInternalStashUserVisitor;
import com.atlassian.stash.internal.user.CaptchaService;
import com.atlassian.stash.internal.user.EmailNotifier;
import com.atlassian.stash.internal.user.InternalDetailedGroup;
import com.atlassian.stash.internal.user.InternalDetailedUser;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.PasswordResetHelper;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.internal.user.UserHelper;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.user.DetailedGroup;
import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.user.ServiceUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserAdminService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=UserAdminService.class)
@Service(value="userAdminService")
public class DefaultUserAdminService
extends AbstractService
implements UserAdminService,
ScheduledJobSource {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserAdminService.class);
    private static final JobId USER_CLEANUP_JOB_ID = JobId.of((String)UserCleanupJob.class.getSimpleName());
    private static final JobRunnerKey USER_CLEANUP_JOB_RUNNER_KEY = JobRunnerKey.of((String)UserCleanupJob.class.getName());
    private final CrowdControl crowdControl;
    private final EmailNotifier emailNotifier;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final PasswordResetHelper passwordResetHelper;
    private final PermissionAdminService permissionAdminService;
    private final StashUserDao userDao;
    private final UserHelper userHelper;
    private final CaptchaService captchaService;
    private final TransactionTemplate requiresNewTransactionTemplate;
    private int maxUserPageSize;
    private int userCleanupJobBatchSize;
    private long userCleanupJobDelay;
    private long userCleanupJobInterval;

    @Autowired
    public DefaultUserAdminService(CrowdControl crowdControl, PermissionAdminService permissionAdminService, PasswordResetHelper passwordResetHelper, EmailNotifier emailNotifier, LicenseService licenseService, I18nService i18nService, UserHelper userHelper, EventPublisher eventPublisher, StashUserDao userDao, CaptchaService captchaService, PlatformTransactionManager transactionManager) {
        this.crowdControl = crowdControl;
        this.permissionAdminService = permissionAdminService;
        this.passwordResetHelper = passwordResetHelper;
        this.emailNotifier = emailNotifier;
        this.licenseService = licenseService;
        this.i18nService = i18nService;
        this.userHelper = userHelper;
        this.eventPublisher = eventPublisher;
        this.userDao = userDao;
        this.captchaService = captchaService;
        this.requiresNewTransactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Value(value="${page.max.users}")
    public void setMaxUserPageSize(int value) {
        this.maxUserPageSize = value;
    }

    @Value(value="${user.cleanup.job.batch.size}")
    public void setUserCleanupJobBatchSize(int value) {
        this.userCleanupJobBatchSize = value;
    }

    @Value(value="${user.cleanup.job.delay}")
    public void setUserCleanupJobDelay(long value) {
        this.userCleanupJobDelay = value;
    }

    @Value(value="${user.cleanup.job.interval}")
    public void setUserCleanupJobInterval(long value) {
        this.userCleanupJobInterval = value;
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void addUserToGroups(@Nonnull String username, @Nonnull Set<String> groupNames) throws ForbiddenException, LicenseLimitException, NoSuchGroupException, NoSuchUserException {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        Preconditions.checkNotNull(groupNames, (Object)"groupNames");
        Preconditions.checkArgument((boolean)Iterables.all(groupNames, (Predicate)Predicates.notNull()), (Object)"groupNames contains a null group name");
        for (String groupName : groupNames) {
            this.doAddUserToGroup(username, groupName);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void addMembersToGroup(@Nonnull String groupName, @Nonnull Set<String> usernames) throws ForbiddenException, LicenseLimitException, NoSuchGroupException, NoSuchUserException {
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        Preconditions.checkNotNull(usernames, (Object)"usernames");
        Preconditions.checkArgument((boolean)Iterables.all(usernames, (Predicate)Predicates.notNull()), (Object)"usernames contains a null username");
        for (String username : usernames) {
            this.doAddUserToGroup(username, groupName);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canCreateGroups() {
        return this.isAllowedInAnyDirectory(OperationType.CREATE_GROUP);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canUpdateGroups() {
        return this.isAllowedInAnyDirectory(OperationType.UPDATE_GROUP);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canCreateUsers() {
        return this.isAllowedInAnyDirectory(OperationType.CREATE_USER);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canDeleteGroups() {
        return this.isAllowedInAnyDirectory(OperationType.DELETE_GROUP);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public void clearCaptchaChallenge(@Nonnull String username) {
        this.captchaService.clearCaptchaChallenge(username);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public InternalDetailedGroup createGroup(@Nonnull String groupName) {
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        this.crowdControl.createGroup((Group)new ImmutableGroup(groupName));
        return new InternalDetailedGroup.Builder().deletable(this.canDeleteGroups()).name(groupName).build();
    }

    @Nonnull
    @Unsecured(value="This should only ever be called by plugins")
    @Transactional
    public ServiceUser createServiceUser(@Nonnull String displayName) {
        Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
        return this.userDao.create(new InternalServiceUser.Builder().displayName(displayName).build());
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void createUser(@Nonnull String username, @Nonnull String password, @Nonnull String displayName, @Nonnull String emailAddress) {
        this.createUser(username, password, displayName, emailAddress, true);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void createUser(@Nonnull String username, @Nonnull String password, @Nonnull String displayName, @Nonnull String emailAddress, boolean addToDefaultGroup) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank display name is required");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)emailAddress, (Object)"emailAddress")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank e-mail address is required");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)password, (Object)"password")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        User user = ImmutableUser.newUser().displayName(displayName).emailAddress(emailAddress).name(username).toUser();
        this.createUser(user, password, addToDefaultGroup);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void createUserWithGeneratedPassword(@Nonnull String username, @Nonnull String displayName, @Nonnull String emailAddress) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank display name is required");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)emailAddress, (Object)"emailAddress")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank e-mail address is required");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        this.emailNotifier.validateCanSendEmails();
        User user = ImmutableUser.newUser().displayName(displayName).emailAddress(emailAddress).name(username).toUser();
        this.createUser(user, this.passwordResetHelper.generatePassword(), true);
        if (!this.crowdControl.canResetPassword(username)) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("stash.service.cant.send.email.passwordReset", new Object[]{Product.NAME}));
        }
        String token = this.passwordResetHelper.addResetPasswordToken(user);
        this.emailNotifier.sendCreatedUser(user, token);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public InternalDetailedGroup deleteGroup(@Nonnull String groupName) {
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        this.permissionAdminService.canDeleteGroup(groupName);
        Group group = this.crowdControl.getGroup(groupName);
        this.crowdControl.deleteGroup(group);
        return new InternalDetailedGroup.Builder().deletable(false).name(groupName).build();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public InternalDetailedUser deleteUser(@Nonnull String username) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        this.permissionAdminService.canDeleteUser(username);
        User user = this.crowdControl.getUser(username);
        this.crowdControl.deleteUser(user);
        return new InternalDetailedUser.Builder((InternalStashUser)this.userHelper.transform(user)).build();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedGroup> findGroups(@Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroups(pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedGroup> findGroupsByName(String groupName, @Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroupsByName(groupName, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedGroup> findGroupsWithUser(@Nonnull String username, String groupName, @Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroupsByUser(username, groupName, false, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedGroup> findGroupsWithoutUser(@Nonnull String username, String groupName, @Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroupsByUser(username, groupName, true, pageRequest));
    }

    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public InternalDetailedUser findUserByPasswordResetToken(@Nonnull String token) {
        User user = this.passwordResetHelper.findUserByResetToken(token);
        return user == null ? null : this.transformUser(user);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedUser> findUsers(@Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformUsers((Page<User>)this.crowdControl.findUsers(pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedUser> findUsersByName(String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformUsers((Page<User>)this.crowdControl.findUsersByName(username, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedUser> findUsersWithGroup(@Nonnull String groupName, String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformUsers((Page<User>)this.crowdControl.findUsersByGroup(groupName, username, false, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<DetailedUser> findUsersWithoutGroup(@Nonnull String groupName, String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformUsers((Page<User>)this.crowdControl.findUsersByGroup(groupName, username, true, pageRequest));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN') or isCurrentUser(#username)")
    public InternalDetailedUser getUserDetails(@Nonnull String username) {
        User user = this.crowdControl.findUser(username, true);
        return user == null ? null : this.transformUser(user);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN') or isCurrentUser(#user)")
    public InternalDetailedUser getUserDetails(@Nonnull StashUser user) {
        if (user instanceof InternalStashUser) {
            return this.transformUser((InternalStashUser)user);
        }
        InternalDetailedUser detailedUser = this.getUserDetails(((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getName());
        if (detailedUser == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("stash.service.user.nosuchuser", new Object[]{user.getName()}), user.getName());
        }
        return detailedUser;
    }

    @EventListener
    public void onGroupDeleted(GroupDeletedEvent event) {
        if (this.crowdControl.findGroup(event.getGroupName()) == null) {
            this.eventPublisher.publish((Object)new GroupCleanupEvent((Object)this, event.getGroupName()));
        }
    }

    @EventListener
    public void onUserDeleted(UserDeletedEvent event) {
        final String username = event.getUsername();
        this.requiresNewTransactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (DefaultUserAdminService.this.crowdControl.findUser(username, true) != null) {
                    return;
                }
                InternalNormalUser stashUser = DefaultUserAdminService.this.userDao.findByName(username);
                if (stashUser != null) {
                    InternalNormalUser userWithDeletedDate = stashUser.copy().deletedDate(new Date()).build();
                    DefaultUserAdminService.this.userDao.update((Object)userWithDeletedDate);
                } else {
                    log.debug("Crowd dispatched a {} for a user ({}) with no corresponding {} and was ignored.", new Object[]{UserDeletedEvent.class.getSimpleName(), StashUser.class.getSimpleName(), username});
                }
            }
        });
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void removeUserFromGroup(@Nonnull String groupName, @Nonnull String username) {
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        this.permissionAdminService.canRemoveUserFromGroup(username, groupName);
        Group group = this.crowdControl.getGroup(groupName);
        User user = this.crowdControl.getUser(username);
        if (!this.crowdControl.removeGroupMember(group, user)) {
            Directory directory = this.crowdControl.findDirectoryFor(user);
            String directoryName = directory == null ? "<Unknown>" : directory.getName();
            log.info(String.format("Failed to remove user %1$s from group %2$s. Group %2$s may not exist in the same directory as the primary user with name %1$s. The 'primary' user is the first user with that name resolved from the ordered list of User Directories.", username, groupName));
            throw new NoSuchGroupException(this.i18nService.createKeyedMessage("stash.service.removeUserFromGroup.notFromGroup", new Object[]{username, directoryName, groupName}), groupName);
        }
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#currentUsername, 'SYS_ADMIN'))")
    public DetailedUser renameUser(@Nonnull String currentUsername, @Nonnull String newUsername) {
        Preconditions.checkNotNull((Object)currentUsername, (Object)"currentUserName");
        Preconditions.checkNotNull((Object)newUsername, (Object)"newUserName");
        User user = this.crowdControl.getUser(currentUsername);
        user = this.crowdControl.renameUser(user, newUsername);
        return this.transformUser(user);
    }

    @Transactional
    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public void requestPasswordReset(@Nonnull String username) throws NoSuchEntityException, MailException {
        User user = this.crowdControl.getUser(username);
        this.emailNotifier.sendPasswordReset(user, this.passwordResetHelper.addResetPasswordToken(user));
    }

    @Transactional
    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public void resetPassword(@Nonnull String token, @Nonnull String password) {
        Preconditions.checkNotNull((Object)token, (Object)"token");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)password, (Object)"password")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        User user = this.passwordResetHelper.findUserByResetToken(token);
        if (user == null) {
            throw new InvalidTokenException(this.i18nService.createKeyedMessage("stash.service.invalidtoken", new Object[0]), token);
        }
        this.passwordResetHelper.resetPassword(user, password);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public void updatePassword(@Nonnull String username, @Nonnull String newPassword) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)newPassword, (Object)"newPassword")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        this.passwordResetHelper.resetPassword(this.crowdControl.getUser(username), newPassword);
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public InternalDetailedUser updateUser(@Nonnull String username, @Nonnull String displayName, @Nonnull String emailAddress) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank display name is required");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)emailAddress, (Object)"emailAddress")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank e-mail address is required");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        User user = this.crowdControl.getUser(username);
        user = this.crowdControl.updateUser(ImmutableUser.newUser((User)user).displayName(displayName).emailAddress(emailAddress).toUser());
        return this.transformUser(user);
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        long interval = TimeUnit.MINUTES.toMillis(this.userCleanupJobInterval);
        UserCleanupJob jobRunner = new UserCleanupJob();
        schedulerService.registerJobRunner(USER_CLEANUP_JOB_RUNNER_KEY, (JobRunner)jobRunner);
        schedulerService.scheduleJob(USER_CLEANUP_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)USER_CLEANUP_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)interval, (Date)new Date(System.currentTimeMillis() + interval))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unregisterJobRunner(USER_CLEANUP_JOB_RUNNER_KEY);
    }

    private void addToGroupIfExisting(User user, String groupName) {
        Group group = this.crowdControl.findGroup(groupName);
        if (group != null) {
            this.licenseService.validateCanAddUserToGroup(user.getName(), groupName);
            this.crowdControl.addGroupMember(group, user);
        }
    }

    private void doAddUserToGroup(@Nonnull String username, @Nonnull String groupName) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        this.permissionAdminService.canAddUserToGroup(groupName);
        this.licenseService.validateCanAddUserToGroup(username, groupName);
        Group group = this.crowdControl.getGroup(groupName);
        User user = this.crowdControl.getUser(username);
        this.crowdControl.addGroupMember(group, user);
    }

    private void createUser(User user, String password, boolean addToDefaultGroup) {
        this.crowdControl.createUser(user, password);
        if (addToDefaultGroup) {
            this.addToGroupIfExisting(user, "stash-users");
        }
    }

    private boolean isAllowedInAnyDirectory(OperationType type) {
        List directories = this.crowdControl.listDirectories();
        for (Directory directory : directories) {
            if (!directory.isActive() || !directory.getAllowedOperations().contains(type)) continue;
            return true;
        }
        return false;
    }

    private Page<DetailedGroup> transformGroups(Page<String> page) {
        return page.transform((Function)new DetailedGroupTransform(this.canDeleteGroups()));
    }

    private InternalDetailedUser transformUser(User user) {
        return this.transformUser((InternalStashUser)this.userHelper.transform(user));
    }

    private InternalDetailedUser transformUser(InternalStashUser user) {
        final InternalDetailedUser.Builder builder = new InternalDetailedUser.Builder(user);
        user.accept((InternalStashUserVisitor)new AbstractVoidInternalStashUserVisitor(){

            protected void doVisit(@Nonnull InternalNormalUser user) {
                Directory directory = DefaultUserAdminService.this.crowdControl.findDirectoryFor(user.getBackingCrowdUser());
                if (directory != null) {
                    Set operations = directory.getAllowedOperations();
                    builder.directoryName(directory.getName()).mutableDetails(operations.contains(OperationType.UPDATE_USER)).mutableGroups(operations.contains(OperationType.UPDATE_GROUP));
                }
            }
        });
        return builder.build();
    }

    private Page<DetailedUser> transformUsers(Page<User> page) {
        return this.userHelper.transform(page).transform((Function)new DetailedUserTransform());
    }

    @VisibleForTesting
    void cleanupDeletedUsers() {
        final Date date = Instant.now().minus((ReadableDuration)Duration.standardMinutes((long)this.userCleanupJobDelay)).toDate();
        final PageRequest request = PageUtils.newRequest((int)0, (int)this.userCleanupJobBatchSize);
        boolean hasMore = true;
        while (hasMore) {
            hasMore = (Boolean)this.requiresNewTransactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction(TransactionStatus status) {
                    Page users = DefaultUserAdminService.this.userDao.findByDeletedDateEarlierThan(date, request);
                    log.debug("Purging {}{} users that have been removed before '{}'", new Object[]{users.getSize(), users.getIsLastPage() ? "" : "+", date});
                    for (InternalNormalUser user : users.getValues()) {
                        DefaultUserAdminService.this.cleanupDeletedUser(user);
                    }
                    return !users.getIsLastPage();
                }
            });
        }
    }

    private void cleanupDeletedUser(InternalNormalUser user) {
        if (!user.isCrowdBacked()) {
            this.eventPublisher.publish((Object)new UserCleanupEvent((Object)this, (StashUser)user.copy().build()));
        }
        InternalNormalUser updatedUser = user.copy().deletedDate(null).build();
        this.userDao.update((Object)updatedUser);
    }

    private class DetailedUserTransform
    implements Function<InternalStashUser, DetailedUser> {
        private DetailedUserTransform() {
        }

        public DetailedUser apply(InternalStashUser user) {
            return DefaultUserAdminService.this.transformUser(user);
        }
    }

    private static class DetailedGroupTransform
    implements Function<String, DetailedGroup> {
        private final InternalDetailedGroup.Builder builder;

        private DetailedGroupTransform(boolean deletable) {
            this.builder = new InternalDetailedGroup.Builder().deletable(deletable);
        }

        public DetailedGroup apply(String group) {
            return this.builder.name(group).build();
        }
    }

    private class UserCleanupJob
    implements JobRunner {
        private UserCleanupJob() {
        }

        public JobRunnerResponse runJob(JobRunnerRequest request) {
            DefaultUserAdminService.this.cleanupDeletedUsers();
            return JobRunnerResponse.success();
        }
    }
}

