/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.topic;

import com.atlassian.hazelcast.serialization.OsgiSafe;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.cluster.HazelcastClusterNode;
import com.atlassian.stash.internal.topic.DefaultMessageEvent;
import com.atlassian.stash.topic.TopicListener;
import com.atlassian.stash.topic.TopicService;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=TopicService.class)
@Component
public class HazelcastTopicService
implements TopicService {
    private static final String TOPIC_PREFIX = "topicService:";
    private static final Logger log = LoggerFactory.getLogger(HazelcastTopicService.class);
    private final HazelcastInstance hazelcast;
    private final ConcurrentMap<String, String> subscriptionToTopic;
    private volatile boolean destroyed;

    @Autowired
    public HazelcastTopicService(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.subscriptionToTopic = Maps.newConcurrentMap();
    }

    @PreDestroy
    public void destroy() {
        this.destroyed = true;
        while (!this.subscriptionToTopic.isEmpty()) {
            Iterator it = this.subscriptionToTopic.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.hazelcast.getTopic((String)entry.getValue()).removeMessageListener((String)entry.getKey());
                it.remove();
            }
        }
    }

    public <T extends Serializable> void publish(@Nonnull String topic, @Nonnull T message) {
        this.checkNotDestroyed();
        String prefixedTopic = HazelcastTopicService.prefixed((String)Preconditions.checkNotNull((Object)topic, (Object)"topic"));
        this.hazelcast.getTopic(prefixedTopic).publish((Object)new OsgiSafe(Preconditions.checkNotNull(message, (Object)"message")));
    }

    @Nonnull
    public <T extends Serializable> String subscribe(final @Nonnull String topic, final @Nonnull TopicListener<T> listener) {
        this.checkNotDestroyed();
        Preconditions.checkNotNull(listener, (Object)"listener");
        String prefixedTopic = HazelcastTopicService.prefixed((String)Preconditions.checkNotNull((Object)topic, (Object)"topic"));
        String registrationId = this.hazelcast.getTopic(prefixedTopic).addMessageListener(new MessageListener<OsgiSafe<T>>(){
            private final Class<T> messageType;
            private final String timerName;
            {
                this.messageType = HazelcastTopicService.this.getMessageType(listener);
                this.timerName = "com.atlassian.stash.topic.TopicListener.onMessage('" + topic + "', T)";
            }

            public void onMessage(Message<OsgiSafe<T>> message) {
                try (Timer ignored = TimerUtils.start((String)this.timerName);){
                    Serializable value = (Serializable)HazelcastTopicService.this.doCast(this.messageType, ((OsgiSafe)message.getMessageObject()).getValue());
                    listener.onMessage(new DefaultMessageEvent<Serializable>(HazelcastClusterNode.transform(message.getPublishingMember()), message.getPublishTime(), topic, value));
                }
                catch (ClassCastException e) {
                    log.warn("Received incompatible message for topic {} from {}: {}", new Object[]{topic, message.getPublishingMember().getUuid(), e.getMessage()});
                }
            }
        });
        this.subscriptionToTopic.put(registrationId, prefixedTopic);
        return registrationId;
    }

    public boolean unsubscribe(@Nonnull String subscriptionId) {
        String prefixedTopic = (String)this.subscriptionToTopic.remove(Preconditions.checkNotNull((Object)subscriptionId, (Object)"subscriptionId"));
        return prefixedTopic != null && this.hazelcast.getTopic(prefixedTopic).removeMessageListener(subscriptionId);
    }

    static String prefixed(String topic) {
        return TOPIC_PREFIX + topic;
    }

    private void checkNotDestroyed() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"The TopicService has already been destroyed");
    }

    private <T> T doCast(Class<T> clazz, Object value) {
        return (T)(clazz == null ? value : clazz.cast(value));
    }

    private <T extends Serializable> Class<T> getMessageType(TopicListener<T> listener) {
        for (Type type : listener.getClass().getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)type).getRawType().equals(TopicListener.class)) continue;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }
}

