/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task;

import com.atlassian.stash.internal.task.InternalTask;
import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="taskPermissionsHelper")
public class TaskPermissionsHelper {
    private final StashAuthenticationContext authenticationContext;
    private final PermissionService permissionService;

    @Autowired
    public TaskPermissionsHelper(StashAuthenticationContext authenticationContext, PermissionService permissionService) {
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
    }

    public boolean hasFullPermission(InternalTaskContext context, InternalTask task) {
        StashUser user = this.authenticationContext.getCurrentUser();
        return task.getAuthor().equals((Object)user) || context.getCreatedBy().equals(user);
    }

    public boolean isRepoAdmin(Repository repository) {
        return this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN);
    }
}

