/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.setting;

import com.atlassian.stash.exception.FormValidationException;
import com.atlassian.stash.internal.setting.DeserializeSettingsException;
import com.atlassian.stash.internal.setting.MapSettingsBuilder;
import com.atlassian.stash.internal.setting.SerializeSettingsException;
import com.atlassian.stash.internal.setting.SettingsHelper;
import com.atlassian.stash.setting.Settings;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Component;

@Component(value="settingsHelper")
public class JacksonSettingsHelper
implements SettingsHelper {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Nonnull
    public Settings deserialize(@Nonnull String data) {
        Preconditions.checkNotNull((Object)data, (Object)"data");
        try {
            return new MapSettingsBuilder().addAll((Map)MAPPER.readValue(data, Map.class)).build();
        }
        catch (IOException e) {
            throw new DeserializeSettingsException("The provided data could not be deserialized from JSON", (Throwable)e);
        }
    }

    @Nonnull
    public String serialize(@Nonnull Settings settings) throws FormValidationException {
        Preconditions.checkNotNull((Object)settings, (Object)"settings");
        try {
            return MAPPER.writeValueAsString((Object)settings.asMap());
        }
        catch (IOException e) {
            throw new SerializeSettingsException("The provided Settings could not be serialized to JSON", (Throwable)e);
        }
    }
}

