/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.ApplicationSetupEvent;
import com.atlassian.stash.event.BaseUrlChangedEvent;
import com.atlassian.stash.event.DisplayNameChangedEvent;
import com.atlassian.stash.event.MailHostConfigurationChangedEvent;
import com.atlassian.stash.event.ServerEmailAddressChangedEvent;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.atlassian.stash.internal.timezone.TimeZoneHelper;
import com.atlassian.stash.mail.MailHostConfiguration;
import com.atlassian.stash.mail.MailProtocol;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.util.CustomPreconditions;
import com.atlassian.stash.util.NumberUtils;
import com.atlassian.stash.util.UrlUtils;
import com.atlassian.stash.util.ValueWrapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.internal.constraintvalidators.EmailValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=ApplicationPropertiesService.class)
@Component(value="applicationPropertiesService")
public class ApplicationPropertiesServiceImpl
implements InternalApplicationPropertiesService {
    private final BuildInfo buildInfo;
    private final Cache<ApplicationProperty.Key, ValueWrapper<String>> cache;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final EventPublisher eventPublisher;
    private final ApplicationPropertyDao propertyDao;
    private final Properties properties;
    private final TransactionTemplate readTx;
    private final ApplicationSettings settings;
    private final TimeZoneHelper timeZoneHelper;
    private final TransactionSynchronizer transactionSynchronizer;
    private volatile boolean setup;

    @Autowired
    public ApplicationPropertiesServiceImpl(ApplicationSettings settings, BuildInfo buildInfo, CacheManager cacheManager, DataSourceConfiguration dataSourceConfiguration, EventPublisher eventPublisher, ApplicationPropertyDao propertyDao, TimeZoneHelper timeZoneHelper, PlatformTransactionManager transactionManager, TransactionSynchronizer transactionSynchronizer, @Qualifier(value="applicationProperties") Properties properties) {
        this.buildInfo = buildInfo;
        this.cache = this.createCache(cacheManager);
        this.dataSourceConfiguration = dataSourceConfiguration;
        this.eventPublisher = eventPublisher;
        this.propertyDao = propertyDao;
        this.properties = properties;
        this.settings = settings;
        this.timeZoneHelper = timeZoneHelper;
        this.transactionSynchronizer = transactionSynchronizer;
        this.readTx = new TransactionTemplate(transactionManager);
        this.readTx.setReadOnly(true);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void deleteMailHostConfiguration() {
        this.deleteOrUpdateMailHostConfiguration(null);
    }

    public String getAvatarSource() {
        return this.getProperty(ApplicationProperty.Key.AVATAR_SOURCE);
    }

    public URI getBaseUrl() {
        return UrlUtils.uncheckedCreateURI((String)this.getProperty(ApplicationProperty.Key.BASE_URL));
    }

    @Nonnull
    public File getBinDir() {
        return this.settings.getBinDir();
    }

    public String getBuildVersion() {
        return this.buildInfo.getBuildVersion();
    }

    public Date getBuildTimestamp() {
        return this.buildInfo.getBuildTimestamp();
    }

    public String getBuildNumber() {
        return this.buildInfo.getBuildNumber();
    }

    @Nonnull
    public File getCacheDir() {
        return this.settings.getCacheDir();
    }

    public String getCommitHash() {
        return this.buildInfo.getCommitHash();
    }

    @Nonnull
    public File getConfigDir() {
        return this.settings.getConfigDir();
    }

    @Nonnull
    public File getDataDir() {
        return this.settings.getDataDir();
    }

    public TimeZone getDefaultTimeZone() {
        return this.timeZoneHelper.getTimeZone();
    }

    public String getDisplayName() {
        return this.getProperty(ApplicationProperty.Key.NAME);
    }

    @Nonnull
    public File getHomeDir() {
        return this.settings.getHomeDir();
    }

    @Nonnull
    public File getSharedHomeDir() {
        return this.settings.getSharedHomeDir();
    }

    public String getJdbcDriver() {
        return this.dataSourceConfiguration.getDriverClassName();
    }

    public String getJdbcDriverVersion() {
        String driverClassName = this.getJdbcDriver();
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver current = e.nextElement();
            if (!current.getClass().getName().equalsIgnoreCase(driverClassName)) continue;
            return String.format("%d.%d", current.getMajorVersion(), current.getMinorVersion());
        }
        return "Unknown";
    }

    public String getJdbcUrl() {
        return this.dataSourceConfiguration.getUrl();
    }

    @Nullable
    public String getLastSharedHomeDir() {
        return this.getProperty(ApplicationProperty.Key.LAST_HOME);
    }

    @Nonnull
    public Locale getLocale() {
        String locale = this.getProperty(ApplicationProperty.Key.LOCALE);
        return locale != null ? LocaleUtils.toLocale((String)locale) : Locale.getDefault();
    }

    public URI getLoginUri(URI redirectUri) {
        String loginUri = this.getBaseUrl() + "/login?next=" + UrlUtils.encodeURL((String)redirectUri.toString());
        return UrlUtils.uncheckedCreateURI((String)loginUri);
    }

    public MailHostConfiguration getMailHostConfiguration() {
        MailHostConfiguration config = new MailHostConfiguration.Builder().hostname(this.getProperty(ApplicationProperty.Key.MAIL_HOST)).port(NumberUtils.parse((String)this.getProperty(ApplicationProperty.Key.MAIL_HOST_PORT), (String)"Configured mail host port is not a number. Using default!")).protocol(MailProtocol.fromString((String)this.getProperty(ApplicationProperty.Key.MAIL_PROTOCOL))).useStartTls(Boolean.parseBoolean(this.getProperty(ApplicationProperty.Key.MAIL_USE_TLS))).requireStartTls(Boolean.parseBoolean(this.getProperty(ApplicationProperty.Key.MAIL_REQUIRE_TLS))).username(this.getProperty(ApplicationProperty.Key.MAIL_HOST_USERNAME)).password(this.getProperty(ApplicationProperty.Key.MAIL_HOST_PASSWORD)).build();
        return config.getHostname() == null && config.getPort() == null && config.getUsername() == null ? null : config;
    }

    public int getMaxCaptchaAttempts() {
        return NumberUtils.parse((String)this.getProperty(ApplicationProperty.Key.MAX_CAPTCHA_ATTEMPTS), (Integer)5, (String)"Configured max captcha attempts is not a number. Using default!");
    }

    public String getPluginProperty(@Nonnull String propertyName) {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName);
    }

    public String getPluginProperty(@Nonnull String propertyName, String defaultValue) {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName, defaultValue);
    }

    public int getPluginProperty(@Nonnull String propertyName, int defaultValue) throws NumberFormatException {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName, defaultValue);
    }

    public long getPluginProperty(@Nonnull String propertyName, long defaultValue) throws NumberFormatException {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName, defaultValue);
    }

    public boolean getPluginProperty(@Nonnull String propertyName, boolean defaultValue) {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName, defaultValue);
    }

    public String getProperty(@Nonnull String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(propertyName);
    }

    public String getProperty(@Nonnull String propertyName, String defaultValue) {
        if (this.properties == null) {
            return defaultValue;
        }
        return this.properties.getProperty(propertyName, defaultValue);
    }

    public int getProperty(@Nonnull String propertyName, int defaultValue) throws NumberFormatException {
        String value = this.getProperty(propertyName);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public long getProperty(@Nonnull String propertyName, long defaultValue) throws NumberFormatException {
        String value = this.getProperty(propertyName);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public boolean getProperty(@Nonnull String propertyName, boolean defaultValue) {
        String value = this.getProperty(propertyName);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public File getRepositoriesDir() {
        return this.settings.getRepositoriesDir();
    }

    @Nonnull
    public File getRepositoryDir(@Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        File root = this.getRepositoriesDir();
        String name = String.valueOf(repository.getId());
        return new File(root, name);
    }

    public String getServerEmailAddress() {
        return this.getProperty(ApplicationProperty.Key.EMAIL_ADDRESS);
    }

    public String getServerId() {
        return this.getProperty(ApplicationProperty.Key.SERVER_ID);
    }

    @Nonnull
    public File getTempDir() {
        return this.settings.getTempDir();
    }

    public boolean isAllowPublicSignUp() {
        return Boolean.valueOf(this.getProperty(ApplicationProperty.Key.ALLOW_PUBLIC_SIGNUP));
    }

    public boolean isDebugLoggingEnabled() {
        String property = this.getProperty(ApplicationProperty.Key.DEBUG_LOGGING_ENABLED);
        return property != null && Boolean.valueOf(property) != false;
    }

    public boolean isProfilingEnabled() {
        String property = this.getProperty(ApplicationProperty.Key.PROFILING_ENABLED);
        return property != null && Boolean.valueOf(property) != false;
    }

    public boolean isSetup() {
        if (!this.setup) {
            this.setup = Boolean.valueOf(this.getProperty(ApplicationProperty.Key.SETUP_COMPLETED));
        }
        return this.setup;
    }

    public boolean isShowCaptchaOnSignUp() {
        return Boolean.valueOf(this.getProperty(ApplicationProperty.Key.REQUIRE_CAPTCHA_ON_SIGNUP));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setAllowPublicSignUp(boolean publicSignUp) {
        this.updateProperty(ApplicationProperty.Key.ALLOW_PUBLIC_SIGNUP, Boolean.toString(publicSignUp));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setAvatarSource(String avatarSource) {
        this.updateProperty(ApplicationProperty.Key.AVATAR_SOURCE, avatarSource);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setBaseURL(@Nonnull URI baseUri) {
        Preconditions.checkNotNull((Object)baseUri);
        String baseUrl = StringUtils.removeEnd((String)baseUri.toString(), (String)"/");
        String oldValue = this.updateProperty(ApplicationProperty.Key.BASE_URL, baseUrl);
        if (ObjectUtils.notEqual((Object)baseUrl, (Object)oldValue)) {
            this.eventPublisher.publish((Object)new BaseUrlChangedEvent((Object)this, oldValue, baseUrl));
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setDebugLoggingEnabled(boolean debugLoggingEnabled) {
        this.updateProperty(ApplicationProperty.Key.DEBUG_LOGGING_ENABLED, Boolean.toString(debugLoggingEnabled));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setDisplayName(@Nonnull String displayName) {
        CustomPreconditions.checkRequiredString((String)displayName, (int)255);
        String oldValue = this.updateProperty(ApplicationProperty.Key.NAME, displayName);
        if (ObjectUtils.notEqual((Object)displayName, (Object)oldValue)) {
            this.eventPublisher.publish((Object)new DisplayNameChangedEvent((Object)this, oldValue, displayName));
        }
    }

    @Transactional
    public void setLastSharedHomeDir(@Nonnull String lastSharedHomeDir) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)lastSharedHomeDir, (Object)"lastSharedHomeDir")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank path is required");
        this.updateProperty(ApplicationProperty.Key.LAST_HOME, lastSharedHomeDir);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setLocale(Locale locale) {
        this.deleteOrUpdate(ApplicationProperty.Key.LOCALE, locale != null ? locale.toString() : null);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setMailHostConfiguration(@Nonnull MailHostConfiguration mailHostConfiguration) {
        this.deleteOrUpdateMailHostConfiguration((MailHostConfiguration)Preconditions.checkNotNull((Object)mailHostConfiguration));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setMaxCaptchaAttempts(int maxCaptchaAttempts) {
        this.updateProperty(ApplicationProperty.Key.MAX_CAPTCHA_ATTEMPTS, Integer.toString(maxCaptchaAttempts));
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setProfilingEnabled(boolean profilingEnabled) {
        this.updateProperty(ApplicationProperty.Key.PROFILING_ENABLED, Boolean.toString(profilingEnabled));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setServerEmailAddress(@Nonnull String emailAddress) {
        Preconditions.checkArgument((boolean)new EmailValidator().isValid((CharSequence)emailAddress, null), (Object)"email address must be valid");
        String oldValue = this.updateProperty(ApplicationProperty.Key.EMAIL_ADDRESS, emailAddress);
        if (ObjectUtils.notEqual((Object)emailAddress, (Object)oldValue)) {
            this.eventPublisher.publish((Object)new ServerEmailAddressChangedEvent((Object)this, oldValue, emailAddress));
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setServerId(String serverId) {
        this.updateProperty(ApplicationProperty.Key.SERVER_ID, serverId);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setSetup(boolean setup) {
        boolean oldValue = this.isSetup();
        if (oldValue != setup) {
            this.updateProperty(ApplicationProperty.Key.SETUP_COMPLETED, Boolean.toString(setup));
            this.eventPublisher.publish((Object)new ApplicationSetupEvent((Object)this, Boolean.valueOf(oldValue), Boolean.valueOf(setup)));
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setShowCaptchaOnSignUp(boolean captchaOnSignUp) {
        this.updateProperty(ApplicationProperty.Key.REQUIRE_CAPTCHA_ON_SIGNUP, Boolean.toString(captchaOnSignUp));
    }

    private Cache<ApplicationProperty.Key, ValueWrapper<String>> createCache(CacheManager cacheManager) {
        CacheLoader<ApplicationProperty.Key, ValueWrapper<String>> cacheLoader = new CacheLoader<ApplicationProperty.Key, ValueWrapper<String>>(){

            @Nonnull
            public ValueWrapper<String> load(@Nonnull ApplicationProperty.Key key) {
                return ApplicationPropertiesServiceImpl.this.wrap(ApplicationPropertiesServiceImpl.this.rawGetProperty(key));
            }
        };
        CacheSettings cacheSettings = new CacheSettingsBuilder().maxEntries(Integer.MAX_VALUE).build();
        return cacheManager.getCache(ApplicationPropertiesService.class.getName(), (CacheLoader)cacheLoader, cacheSettings);
    }

    private void delete(ApplicationProperty.Key ... keys) {
        for (ApplicationProperty.Key key : keys) {
            this.deleteOrUpdate(key, null);
        }
    }

    private String deleteOrUpdate(final ApplicationProperty.Key key, @Nullable Object newValue) {
        final String oldValue = this.unwrap((ValueWrapper<String>)((ValueWrapper)this.cache.get((Object)key)));
        final String value = Objects.toString(newValue, null);
        if (newValue == null) {
            if (oldValue != null) {
                this.propertyDao.deleteById(key);
            }
        } else {
            ApplicationProperty newProperty = new ApplicationProperty(key, value);
            if (oldValue == null) {
                this.propertyDao.create(newProperty);
            } else {
                this.propertyDao.update(newProperty);
            }
        }
        this.transactionSynchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                if (!ApplicationPropertiesServiceImpl.this.cache.replace((Object)key, (Object)ApplicationPropertiesServiceImpl.this.wrap(oldValue), (Object)ApplicationPropertiesServiceImpl.this.wrap(value))) {
                    ApplicationPropertiesServiceImpl.this.cache.remove((Object)key);
                }
            }
        });
        return oldValue;
    }

    private void deleteOrUpdateMailHostConfiguration(MailHostConfiguration mailHostConfiguration) {
        MailHostConfiguration oldValue = this.getMailHostConfiguration();
        if (mailHostConfiguration == null) {
            this.delete(ApplicationProperty.Key.MAIL_HOST, ApplicationProperty.Key.MAIL_HOST_PORT, ApplicationProperty.Key.MAIL_HOST_USERNAME, ApplicationProperty.Key.MAIL_HOST_PASSWORD, ApplicationProperty.Key.MAIL_PROTOCOL, ApplicationProperty.Key.MAIL_USE_TLS, ApplicationProperty.Key.MAIL_REQUIRE_TLS);
        } else {
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST, mailHostConfiguration.getHostname());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST_PORT, mailHostConfiguration.getPort());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST_USERNAME, mailHostConfiguration.getUsername());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST_PASSWORD, mailHostConfiguration.getPassword());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_PROTOCOL, mailHostConfiguration.getProtocol().name());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_USE_TLS, mailHostConfiguration.isUseStartTls());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_REQUIRE_TLS, mailHostConfiguration.isRequireStartTls());
        }
        if (ObjectUtils.notEqual((Object)mailHostConfiguration, (Object)oldValue)) {
            this.eventPublisher.publish((Object)new MailHostConfigurationChangedEvent((Object)this, oldValue, mailHostConfiguration));
        }
    }

    private String getProperty(ApplicationProperty.Key key) {
        try {
            return this.unwrap((ValueWrapper<String>)((ValueWrapper)this.cache.get((Object)key)));
        }
        catch (CacheException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private String rawGetProperty(final ApplicationProperty.Key key) {
        ApplicationProperty property = (ApplicationProperty)this.readTx.execute((TransactionCallback)new TransactionCallback<ApplicationProperty>(){

            public ApplicationProperty doInTransaction(TransactionStatus status) {
                return ApplicationPropertiesServiceImpl.this.propertyDao.getById(key);
            }
        });
        return property == null ? null : property.getValue();
    }

    private String unwrap(ValueWrapper<String> wrapper) {
        return wrapper == null ? null : (String)((Object)wrapper.get());
    }

    private String updateProperty(ApplicationProperty.Key key, @Nonnull String newValue) {
        Preconditions.checkNotNull((Object)newValue);
        return this.deleteOrUpdate(key, newValue);
    }

    private void validatePluginPropertyName(String propertyName) {
        Preconditions.checkNotNull((Object)propertyName, (Object)"Property name must not be null");
        Preconditions.checkArgument((boolean)propertyName.startsWith("plugin."), (Object)("Property name \"" + propertyName + "\" does not start with \"plugin.\""));
    }

    private ValueWrapper<String> wrap(String value) {
        return new ValueWrapper((Serializable)((Object)value));
    }
}

