/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.stash.compare.CompareRequest;
import com.atlassian.stash.content.ChangeCallback;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.content.DiffContentCallback;
import com.atlassian.stash.scm.Command;
import com.atlassian.stash.scm.compare.CompareChangeCommandParameters;
import com.atlassian.stash.scm.compare.CompareDiffCommandParameters;
import com.atlassian.stash.scm.compare.PluginCompareCommandFactory;
import com.atlassian.stash.scm.compare.ScmCompareCommandFactory;
import javax.annotation.Nonnull;

public class PluginScmCompareCommandFactory
implements ScmCompareCommandFactory {
    private final CompareRequest compareRequest;
    private final PluginCompareCommandFactory commandFactory;

    public PluginScmCompareCommandFactory(CompareRequest compareRequest, PluginCompareCommandFactory commandFactory) {
        this.compareRequest = compareRequest;
        this.commandFactory = commandFactory;
    }

    @Nonnull
    public Command<Void> changes(@Nonnull CompareChangeCommandParameters parameters, @Nonnull ChangeCallback callback) {
        return this.commandFactory.changes(this.compareRequest, parameters, callback);
    }

    @Nonnull
    public Command<Void> commits(@Nonnull ChangesetCallback callback) {
        return this.commandFactory.commits(this.compareRequest, callback);
    }

    @Nonnull
    public Command<Void> diff(@Nonnull CompareDiffCommandParameters parameters, @Nonnull DiffContentCallback callback) {
        return this.commandFactory.diff(this.compareRequest, parameters, callback);
    }
}

