/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.stash.commit.CommitEnricher;
import com.atlassian.stash.content.AbstractChangesetCallback;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.atlassian.stash.internal.pull.InternalRescopeDetails;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction;
import com.atlassian.stash.internal.pull.rescope.RescopeProcessor;
import com.atlassian.stash.pull.AbstractPullRequestActivityVisitor;
import com.atlassian.stash.pull.PullRequestActivityVisitor;
import com.atlassian.stash.pull.PullRequestRescopeActivity;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.CommitsCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RescopePullRequestActivityEnricher
implements PullRequestActivityEnricher {
    private static final Predicate<InternalPullRequestRescopeActivity> IS_PRECALCULATED = new Predicate<InternalPullRequestRescopeActivity>(){

        public boolean apply(InternalPullRequestRescopeActivity activity) {
            return activity.isPrecalculated();
        }
    };
    private static final Function<InternalPullRequestRescopeCommit, String> TO_COMMIT_ID = new Function<InternalPullRequestRescopeCommit, String>(){

        public String apply(InternalPullRequestRescopeCommit commit) {
            return commit.getChangesetId();
        }
    };
    private final CommitEnricher commitEnricher;
    private final RescopeProcessor rescopeProcessor;
    private final ScmService scmService;

    @Autowired
    public RescopePullRequestActivityEnricher(CommitEnricher commitEnricher, RescopeProcessor rescopeProcessor, ScmService scmService) {
        this.commitEnricher = commitEnricher;
        this.rescopeProcessor = rescopeProcessor;
        this.scmService = scmService;
    }

    @Override
    public void enrich(@Nonnull InternalPullRequest pullRequest, @Nonnull Iterable<InternalPullRequestActivity> activities) {
        String timerName = "Enrich: Rescopes from " + pullRequest.getGlobalId() + " (" + Iterables.size(activities) + ")";
        try (Timer ignored = TimerUtils.start((String)timerName);){
            WinnowingVisitor visitor = new WinnowingVisitor();
            for (InternalPullRequestActivity activity : activities) {
                activity.accept((PullRequestActivityVisitor)visitor);
            }
            List<InternalPullRequestRescopeActivity> rescopes = visitor.getActivities();
            if (!rescopes.isEmpty()) {
                this.rescopeProcessor.processAll(pullRequest, rescopes);
                this.applyCommits(pullRequest, rescopes);
            }
        }
    }

    private void applyCommits(InternalPullRequest pullRequest, List<InternalPullRequestRescopeActivity> all) {
        Collection activities = Collections2.filter(all, IS_PRECALCULATED);
        Set commitIds = Chainable.chain((Iterable)activities).flatMap((Function)new Function<InternalPullRequestRescopeActivity, Iterable<String>>(){

            public Iterable<String> apply(InternalPullRequestRescopeActivity activity) {
                return Iterables.transform((Iterable)activity.getCommits(), (Function)TO_COMMIT_ID);
            }
        }).toSet();
        if (commitIds.isEmpty()) {
            return;
        }
        Iterable<Changeset> commits = this.loadCommits(pullRequest, commitIds);
        ImmutableMap commitsById = Maps.uniqueIndex(commits, (Function)Changeset.TO_ID);
        for (InternalPullRequestRescopeActivity activity : activities) {
            InternalRescopeDetails.Builder added = new InternalRescopeDetails.Builder().total(activity.getTotalAdded());
            InternalRescopeDetails.Builder removed = new InternalRescopeDetails.Builder().total(activity.getTotalRemoved());
            for (InternalPullRequestRescopeCommit rescopeCommit : activity.getCommits()) {
                Changeset commit = (Changeset)commitsById.get(rescopeCommit.getChangesetId());
                if (commit == null) continue;
                if (rescopeCommit.getAction() == PullRequestRescopeCommitAction.ADDED) {
                    added.changeset(commit);
                    continue;
                }
                removed.changeset(commit);
            }
            activity.setAdded(added.build());
            activity.setRemoved(removed.build());
        }
    }

    private Iterable<Changeset> loadCommits(InternalPullRequest pullRequest, Set<String> commitIds) {
        final ArrayList commits = Lists.newArrayListWithCapacity((int)commitIds.size());
        this.scmService.getCommandFactory((Repository)pullRequest.getScopeRepository()).commits(new CommitsCommandParameters.Builder().include(commitIds).secondaryRepository((Repository)pullRequest.getFromRef().getRepository()).traverse(false).build(), (ChangesetCallback)new AbstractChangesetCallback(){

            public boolean onChangeset(@Nonnull Changeset commit) {
                commits.add(commit);
                return true;
            }
        }).call();
        return this.commitEnricher.enrich((Repository)pullRequest.getScopeRepository(), (Iterable)commits, null);
    }

    private static class WinnowingVisitor
    extends AbstractPullRequestActivityVisitor {
        private final ImmutableList.Builder<InternalPullRequestRescopeActivity> builder = ImmutableList.builder();

        private WinnowingVisitor() {
        }

        public List<InternalPullRequestRescopeActivity> getActivities() {
            return this.builder.build();
        }

        public void visit(@Nonnull PullRequestRescopeActivity activity) {
            this.builder.add((Object)((InternalPullRequestRescopeActivity)activity));
        }
    }
}

