/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.rescope.InternalPullRequestRescopeService;
import com.atlassian.stash.internal.pull.rescope.RepositoryRescopeResult;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestRef;
import com.atlassian.stash.pull.PullRequestSearchRequest;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.pull.MinimalPullRequest;
import com.atlassian.stash.scm.pull.RepositoryRescopeCommandParameters;
import com.atlassian.stash.scm.pull.RepositoryRescopeContext;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.PagedIterable;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class DefaultPullRequestRescopeService
implements InternalPullRequestRescopeService {
    public static final int MAX_RESCOPE_ATTEMPTS = 3;
    private static final Function<PullRequest, MinimalPullRequest> MINIMIZER = new Function<PullRequest, MinimalPullRequest>(){

        public SimpleMinimalPullRequest apply(PullRequest pullRequest) {
            return new SimpleMinimalPullRequest(pullRequest);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DefaultPullRequestRescopeService.class);
    private final RescopeUpdateStrategy decline = new RescopeUpdateStrategy(){

        @Override
        public void apply(SimpleMinimalPullRequest pullRequest) {
            DefaultPullRequestRescopeService.this.pullRequestService.decline(pullRequest.globalId, pullRequest.version);
        }

        @Override
        public String getErrorFormat() {
            return "Could not decline pull request %1$s";
        }
    };
    private final RescopeUpdateStrategy merge = new RescopeUpdateStrategy(){

        @Override
        public void apply(SimpleMinimalPullRequest pullRequest) {
            DefaultPullRequestRescopeService.this.pullRequestService.closeMerged(pullRequest.globalId, pullRequest.version);
        }

        @Override
        public String getErrorFormat() {
            return "Could not mark pull request %1$s as merged";
        }
    };
    private final RescopeUpdateStrategy rescope = new RescopeUpdateStrategy(){

        @Override
        public void apply(SimpleMinimalPullRequest pullRequest) {
            DefaultPullRequestRescopeService.this.pullRequestService.updateScope(pullRequest.globalId, pullRequest.version, pullRequest.newFromHash, pullRequest.newToHash);
        }

        @Override
        public String getErrorFormat() {
            return "Could not rescope pull request %1$s";
        }
    };
    private final InternalPullRequestService pullRequestService;
    private final InternalScmService scmService;
    private final SecurityService securityService;

    public DefaultPullRequestRescopeService(InternalPullRequestService pullRequestService, InternalScmService scmService, SecurityService securityService) {
        this.pullRequestService = pullRequestService;
        this.scmService = scmService;
        this.securityService = securityService;
    }

    @Nonnull
    public RepositoryRescopeResult rescopeFor(@Nonnull StashUser user, final @Nonnull Repository repository, final String branchId) {
        try (Timer ignored = TimerUtils.start((String)("Rescoping pull requests for " + repository.toString()));){
            RepositoryRescopeResult repositoryRescopeResult = (RepositoryRescopeResult)this.securityService.impersonating(user, "Rescoping pull requests").withPermission(Permission.REPO_READ).call((Operation)new UncheckedOperation<RepositoryRescopeResult>(){

                public RepositoryRescopeResult perform() {
                    RepositoryRescopeResult result;
                    int attempt = 1;
                    while ((result = DefaultPullRequestRescopeService.this.attemptUpdatePullRequestsFor(repository, branchId, attempt)).hasErrors() && attempt++ < 3) {
                    }
                    return result;
                }
            });
            return repositoryRescopeResult;
        }
    }

    private RepositoryRescopeResult attemptUpdatePullRequestsFor(Repository repository, String branchId, int attempt) {
        int lockedCount = 0;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (PullRequest pullRequest : this.findAffectedPullRequests(repository, branchId)) {
            if (pullRequest.isLocked()) {
                ++lockedCount;
                continue;
            }
            builder.add(MINIMIZER.apply((Object)pullRequest));
        }
        ImmutableSet pullRequests = builder.build();
        if (pullRequests.isEmpty()) {
            return new RepositoryRescopeResult(lockedCount, 0);
        }
        SimpleRepositoryRescopeContext context = new SimpleRepositoryRescopeContext((Set<MinimalPullRequest>)pullRequests);
        this.scmService.rescope(new RepositoryRescopeCommandParameters.Builder().repository(repository).rescopeContext((RepositoryRescopeContext)context).build());
        int failureCount = DefaultPullRequestRescopeService.applyUpdate(context.declined, this.decline, attempt) + DefaultPullRequestRescopeService.applyUpdate(context.merged, this.merge, attempt) + DefaultPullRequestRescopeService.applyUpdate(context.updated, this.rescope, attempt);
        return new RepositoryRescopeResult(lockedCount, failureCount);
    }

    private Iterable<PullRequest> findAffectedPullRequests(final Repository repository, final String branchId) {
        PageRequest initialPageRequest = PageUtils.newRequest((int)0, (int)100);
        return Iterables.concat((Iterable)new PagedIterable((PageProvider)new PageProvider<PullRequest>(){

            public Page<PullRequest> get(PageRequest pageRequest) {
                return DefaultPullRequestRescopeService.this.pullRequestService.search(new PullRequestSearchRequest.Builder().toBranchId(branchId).toRepositoryId(repository.getId()).state(PullRequestState.OPEN).build(), pageRequest);
            }
        }, initialPageRequest), (Iterable)new PagedIterable((PageProvider)new PageProvider<PullRequest>(){

            public Page<PullRequest> get(PageRequest pageRequest) {
                return DefaultPullRequestRescopeService.this.pullRequestService.search(new PullRequestSearchRequest.Builder().fromBranchId(branchId).fromRepositoryId(repository.getId()).state(PullRequestState.OPEN).build(), pageRequest);
            }
        }, initialPageRequest));
    }

    private static int applyUpdate(Set<SimpleMinimalPullRequest> pullRequests, RescopeUpdateStrategy strategy, int attempt) {
        int failures = 0;
        for (SimpleMinimalPullRequest pullRequest : pullRequests) {
            try {
                strategy.apply(pullRequest);
            }
            catch (RuntimeException e) {
                ++failures;
                DefaultPullRequestRescopeService.logFailure(String.format(strategy.getErrorFormat(), pullRequest), e, attempt);
            }
        }
        return failures;
    }

    private static void logFailure(String message, Throwable throwable, int attempt) {
        if (attempt < 3) {
            log.debug(message, throwable);
        } else {
            log.warn(message, throwable);
        }
    }

    private static class SimpleMinimalPullRequest
    implements MinimalPullRequest {
        private final PullRequestRef fromRef;
        private final long globalId;
        private final long id;
        private final PullRequestRef toRef;
        private final int version;
        private String newFromHash;
        private String newToHash;

        private SimpleMinimalPullRequest(PullRequest pullRequest) {
            this.fromRef = pullRequest.getFromRef();
            this.globalId = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).getGlobalId();
            this.id = pullRequest.getId();
            this.toRef = pullRequest.getToRef();
            this.version = pullRequest.getVersion();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof SimpleMinimalPullRequest && this.globalId == ((SimpleMinimalPullRequest)o).globalId;
        }

        @Nonnull
        public PullRequestRef getFromRef() {
            return this.fromRef;
        }

        public long getId() {
            return this.id;
        }

        @Nonnull
        public PullRequestRef getToRef() {
            return this.toRef;
        }

        public int getVersion() {
            return this.version;
        }

        public int hashCode() {
            return ObjectUtils.hashCode((long)this.globalId);
        }

        public String toString() {
            return this.toRef.getRepository().getProject().getKey() + "/" + this.toRef.getRepository().getSlug() + "#" + this.id;
        }
    }

    private static class SimpleRepositoryRescopeContext
    implements RepositoryRescopeContext {
        private final Set<SimpleMinimalPullRequest> declined;
        private final Set<SimpleMinimalPullRequest> merged;
        private final Set<MinimalPullRequest> pullRequests;
        private final Set<SimpleMinimalPullRequest> updated;

        public SimpleRepositoryRescopeContext(Set<MinimalPullRequest> pullRequests) {
            this.pullRequests = pullRequests;
            this.declined = Sets.newHashSet();
            this.merged = Sets.newHashSet();
            this.updated = Sets.newHashSet();
        }

        public void decline(@Nonnull MinimalPullRequest pullRequest) {
            this.declined.add(SimpleRepositoryRescopeContext.checkPullRequest(pullRequest));
        }

        public Iterator<MinimalPullRequest> iterator() {
            return this.pullRequests.iterator();
        }

        public void merge(@Nonnull MinimalPullRequest pullRequest) {
            this.merged.add(SimpleRepositoryRescopeContext.checkPullRequest(pullRequest));
        }

        public void update(@Nonnull MinimalPullRequest pullRequest, @Nonnull String newFromHash, @Nonnull String newToHash) {
            SimpleMinimalPullRequest minimal = SimpleRepositoryRescopeContext.checkPullRequest(pullRequest);
            minimal.newFromHash = newFromHash;
            minimal.newToHash = newToHash;
            this.updated.add(minimal);
        }

        private static SimpleMinimalPullRequest checkPullRequest(MinimalPullRequest pullRequest) {
            Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
            Preconditions.checkArgument((boolean)(pullRequest instanceof SimpleMinimalPullRequest), (Object)"The provided MinimalPullRequest does not belong to this RepositoryRescopeContext");
            return (SimpleMinimalPullRequest)pullRequest;
        }
    }

    private static interface RescopeUpdateStrategy {
        public void apply(SimpleMinimalPullRequest var1);

        public String getErrorFormat();
    }
}

