/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.stash.content.AbstractDiffContentCallback;
import com.atlassian.stash.content.ConflictMarker;
import com.atlassian.stash.content.DiffContentCallback;
import com.atlassian.stash.content.DiffSegmentType;
import com.atlassian.stash.content.DiffSummary;
import com.atlassian.stash.content.Path;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.internal.pull.comment.drift.DriftResult;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.Command;
import com.atlassian.stash.scm.DiffCommandParameters;
import com.atlassian.stash.scm.ScmCommandFactory;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class DiffCommentDriftStrategy
implements CommentDriftStrategy,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(DiffCommentDriftStrategy.class);
    private final ScmService scmService;
    @Value(value="${pullrequest.diff.context}")
    private int diffContext;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;

    @Autowired
    public DiffCommentDriftStrategy(ScmService scmService) {
        this.scmService = scmService;
    }

    @Override
    public void apply(@Nonnull DriftContext context) {
        DriftResult result = this.processAnchors(context);
        result.applyTo(context);
    }

    @Override
    public String getName() {
        return "Diff";
    }

    public int getOrder() {
        return 0;
    }

    private DriftResult calculateDrift(ScmCommandFactory commandFactory, String untilId, String sinceId, Iterable<InternalPullRequestDiffCommentAnchor> anchors) {
        DiffCommandParameters.Builder parameters = ((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(0)).maxLineLength(this.maxLineLength)).maxLines(Integer.MAX_VALUE)).sinceId(sinceId).untilId(untilId);
        DriftDiffContentCallback callback = new DriftDiffContentCallback(anchors);
        commandFactory.diff(parameters.build(), (DiffContentCallback)callback).call();
        return callback.getResult();
    }

    private DriftResult calculateDriftInSource(DriftContext context, ScmCommandFactory commandFactory, Map<DiffSegmentType, List<InternalPullRequestDiffCommentAnchor>> anchorsByType) {
        InternalPullRequest pullRequest = context.getPullRequest();
        List<InternalPullRequestDiffCommentAnchor> addAnchors = anchorsByType.get(DiffSegmentType.ADDED);
        if (addAnchors.isEmpty()) {
            log.debug("{}: No comments have been anchored to ADDED lines; skipping drift calculation", (Object)pullRequest.getGlobalId());
            return new DriftResult();
        }
        String previousMergeHash = context.getPreviousDiff().getUntilId();
        String mergeHash = context.getCurrentDiff().getUntilId();
        if (log.isDebugEnabled()) {
            log.debug("{}: Calculating drift from {} to {} for {} anchors on ADDED lines", new Object[]{pullRequest.getGlobalId(), previousMergeHash, mergeHash, addAnchors.size()});
        }
        String timerName = "Drift: " + this.getName() + " - Merge diff [" + previousMergeHash + "]->[" + mergeHash + "] " + pullRequest.getGlobalId();
        try (Timer timer = TimerUtils.start((String)timerName);){
            DriftResult driftResult = this.calculateDrift(commandFactory, mergeHash, previousMergeHash, addAnchors);
            return driftResult;
        }
    }

    private DriftResult calculateDriftInTarget(DriftContext context, ScmCommandFactory commandFactory, Map<DiffSegmentType, List<InternalPullRequestDiffCommentAnchor>> anchorsByType) {
        String toHash;
        InternalPullRequest pullRequest = context.getPullRequest();
        List<InternalPullRequestDiffCommentAnchor> contextAnchors = anchorsByType.get(DiffSegmentType.CONTEXT);
        List<InternalPullRequestDiffCommentAnchor> removedAnchors = anchorsByType.get(DiffSegmentType.REMOVED);
        if (contextAnchors.isEmpty() && removedAnchors.isEmpty()) {
            log.debug("{}: No comments have been anchored to CONTEXT or REMOVED lines; skipping drift calculation", (Object)pullRequest.getGlobalId());
            return new DriftResult();
        }
        Iterable anchors = Iterables.concat(contextAnchors, removedAnchors);
        String previousToHash = context.getPreviousToHash();
        if (previousToHash.equals(toHash = context.getPullRequest().getToRef().getLatestChangeset())) {
            log.debug("{}: The target branch has not been updated; skipping drift calculation", (Object)pullRequest.getGlobalId());
            return DriftResult.forRetained(anchors);
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: Calculating drift from {} to {} for {}/{} anchors on CONTEXT/REMOVED lines", new Object[]{pullRequest.getGlobalId(), previousToHash, toHash, contextAnchors.size(), removedAnchors.size()});
        }
        String timerName = "Drift: " + this.getName() + " - Target diff [" + previousToHash + "]->[" + toHash + "] " + pullRequest.getGlobalId();
        try (Timer timer = TimerUtils.start((String)timerName);){
            DriftResult driftResult = this.calculateDrift(commandFactory, toHash, previousToHash, anchors);
            return driftResult;
        }
    }

    private Set<DriftResult.ProcessedAnchor> detectOrphans(DriftContext context, ScmCommandFactory commandFactory, DriftResult sourceDrift, DriftResult targetDrift) {
        InternalPullRequest pullRequest = context.getPullRequest();
        List<DriftResult.ProcessedAnchor> sourceReachable = sourceDrift.getReachableAnchors();
        List<DriftResult.ProcessedAnchor> targetReachable = targetDrift.getReachableAnchors();
        if (sourceReachable.isEmpty() && targetReachable.isEmpty()) {
            log.debug("{}: After calculating drift, all comments have been orphaned", (Object)pullRequest.getGlobalId());
            return Collections.emptySet();
        }
        Iterable reachable = Iterables.concat(sourceReachable, targetReachable);
        if (log.isDebugEnabled()) {
            log.debug("{}: Validating {} anchor(s)", (Object)pullRequest.getGlobalId(), (Object)(sourceReachable.size() + targetReachable.size()));
        }
        PullRequestEffectiveDiff currentDiff = context.getCurrentDiff();
        DiffCommandParameters.Builder parameters = ((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(Integer.MAX_VALUE)).sinceId(currentDiff.getSinceId()).untilId(currentDiff.getUntilId());
        OrphanDetectingDiffContentCallback callback = new OrphanDetectingDiffContentCallback(reachable);
        Command command = commandFactory.diff(parameters.build(), (DiffContentCallback)callback);
        String timerName = "Drift: " + this.getName() + " - Effective diff [" + currentDiff.getSinceId() + "]->[" + currentDiff.getUntilId() + "] " + pullRequest.getGlobalId();
        try (Timer timer = TimerUtils.start((String)timerName);){
            command.call();
        }
        return callback.done();
    }

    private static Map<DiffSegmentType, List<InternalPullRequestDiffCommentAnchor>> mapAnchorsByType(DriftContext context) {
        EnumMap anchorsByType = Maps.newEnumMap(DiffSegmentType.class);
        for (DiffSegmentType value : DiffSegmentType.values()) {
            anchorsByType.put(value, Lists.newArrayList());
        }
        for (InternalPullRequestDiffCommentAnchor anchor : context) {
            if (anchor.getLineType() == null) continue;
            ((List)anchorsByType.get(anchor.getLineType())).add(anchor);
        }
        return anchorsByType;
    }

    private DriftResult processAnchors(DriftContext context) {
        Map<DiffSegmentType, List<InternalPullRequestDiffCommentAnchor>> anchorsByType = DiffCommentDriftStrategy.mapAnchorsByType(context);
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory((Repository)context.getRepository());
        DriftResult sourceDrift = this.calculateDriftInSource(context, commandFactory, anchorsByType);
        DriftResult targetDrift = this.calculateDriftInTarget(context, commandFactory, anchorsByType);
        Set<DriftResult.ProcessedAnchor> orphaned = this.detectOrphans(context, commandFactory, sourceDrift, targetDrift);
        return sourceDrift.merge(targetDrift).orphan(Iterables.transform(orphaned, DriftResult.ProcessedAnchor.TO_ANCHOR));
    }

    private static class OrphanDetectingDiffContentCallback
    extends AbstractDiffContentCallback {
        private final Map<String, Map<DiffSegmentType, Map<Integer, List<DriftResult.ProcessedAnchor>>>> typesByPath = Maps.newHashMap();
        private int currentDestinationLine;
        private String currentPath;
        private Map<DiffSegmentType, Map<Integer, List<DriftResult.ProcessedAnchor>>> currentPathTypes;
        private DiffSegmentType currentSegmentType;
        private Map<Integer, List<DriftResult.ProcessedAnchor>> currentTypeLines;
        private int currentSourceLine;

        private OrphanDetectingDiffContentCallback(Iterable<DriftResult.ProcessedAnchor> processedAnchors) {
            for (DriftResult.ProcessedAnchor processedAnchor : processedAnchors) {
                List anchors;
                Map anchorsByLine;
                HashMap linesByType = this.typesByPath.get(processedAnchor.getPath());
                if (linesByType == null) {
                    linesByType = Maps.newHashMap();
                    this.typesByPath.put(processedAnchor.getPath(), linesByType);
                }
                if ((anchorsByLine = (Map)linesByType.get(processedAnchor.getLineType())) == null) {
                    anchorsByLine = Maps.newHashMap();
                    linesByType.put(processedAnchor.getLineType(), anchorsByLine);
                }
                if ((anchors = (List)anchorsByLine.get(processedAnchor.getLine())) == null) {
                    anchors = Lists.newArrayList();
                    anchorsByLine.put(processedAnchor.getLine(), anchors);
                }
                anchors.add(processedAnchor);
            }
        }

        public Set<DriftResult.ProcessedAnchor> done() {
            HashSet notFound = Sets.newHashSet();
            for (Map<DiffSegmentType, Map<Integer, List<DriftResult.ProcessedAnchor>>> linesByType : this.typesByPath.values()) {
                for (Map<Integer, List<DriftResult.ProcessedAnchor>> anchorsByLine : linesByType.values()) {
                    for (List<DriftResult.ProcessedAnchor> anchors : anchorsByLine.values()) {
                        notFound.addAll(anchors);
                    }
                }
            }
            return notFound;
        }

        public void onDiffEnd(boolean truncated) throws IOException {
            this.currentPath = null;
            this.currentPathTypes = null;
        }

        public void onDiffStart(@Nullable Path src, @Nullable Path dst) throws IOException {
            if (dst != null) {
                this.currentPath = dst.toString();
            } else if (src != null) {
                this.currentPath = src.toString();
            }
            this.currentPathTypes = this.typesByPath.get(this.currentPath);
        }

        public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan) {
            this.currentDestinationLine = dstLine;
            this.currentSourceLine = srcLine;
        }

        public void onSegmentEnd(boolean truncated) {
            this.currentSegmentType = null;
            this.currentTypeLines = null;
        }

        public void onSegmentLine(@Nonnull String line, @Nullable ConflictMarker marker, boolean truncated) {
            if (this.currentSegmentType == null) {
                return;
            }
            int commentLine = this.chooseCommentLineAndIncrementLines();
            if (this.currentTypeLines != null && this.currentTypeLines.containsKey(commentLine)) {
                this.currentTypeLines.remove(commentLine);
                if (this.currentTypeLines.isEmpty()) {
                    this.currentTypeLines = null;
                    this.currentPathTypes.remove(this.currentSegmentType);
                    if (this.currentPathTypes.isEmpty()) {
                        this.currentPathTypes = null;
                        this.currentSegmentType = null;
                        this.typesByPath.remove(this.currentPath);
                    }
                }
            }
        }

        public void onSegmentStart(@Nonnull DiffSegmentType type) {
            if (this.currentPathTypes != null) {
                this.currentSegmentType = type;
                this.currentTypeLines = this.currentPathTypes.get(type);
            }
        }

        private int chooseCommentLineAndIncrementLines() {
            switch (this.currentSegmentType) {
                case ADDED: {
                    return this.currentDestinationLine++;
                }
                case CONTEXT: {
                    ++this.currentDestinationLine;
                }
            }
            return this.currentSourceLine++;
        }
    }

    private static class DriftDiffContentCallback
    extends AbstractDiffContentCallback {
        private final Map<String, List<InternalPullRequestDiffCommentAnchor>> anchorsByPath = Maps.newHashMap();
        private final DriftResult result = new DriftResult();
        private List<InternalPullRequestDiffCommentAnchor> workingAnchors;
        private int workingDrift;

        private DriftDiffContentCallback(Iterable<InternalPullRequestDiffCommentAnchor> anchors) {
            for (InternalPullRequestDiffCommentAnchor anchor : anchors) {
                ArrayList byPath = this.anchorsByPath.get(anchor.getPath());
                if (byPath == null) {
                    byPath = Lists.newArrayList();
                    this.anchorsByPath.put(anchor.getPath(), byPath);
                }
                byPath.add(anchor);
            }
        }

        public DriftResult getResult() {
            return this.result;
        }

        public void onDiffEnd(boolean truncated) {
            if (CollectionUtils.isNotEmpty(this.workingAnchors)) {
                for (InternalPullRequestDiffCommentAnchor anchor : this.workingAnchors) {
                    this.drift(anchor);
                }
                this.workingAnchors = null;
            }
        }

        public void onDiffStart(@Nullable Path src, @Nullable Path dst) {
            if (src != null) {
                this.workingAnchors = this.anchorsByPath.remove(src.toString());
            }
            this.workingDrift = 0;
        }

        public void onEnd(@Nonnull DiffSummary summary) {
            for (List<InternalPullRequestDiffCommentAnchor> anchors : this.anchorsByPath.values()) {
                for (InternalPullRequestDiffCommentAnchor anchor : anchors) {
                    this.result.retain(anchor, new InternalPullRequestDiffCommentAnchor[0]);
                }
            }
        }

        public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan) {
            if (this.workingAnchors == null) {
                return;
            }
            int endLine = srcLine + srcSpan;
            Iterator<InternalPullRequestDiffCommentAnchor> anchorIterator = this.workingAnchors.iterator();
            while (anchorIterator.hasNext()) {
                InternalPullRequestDiffCommentAnchor anchor = anchorIterator.next();
                int anchorLine = anchor.getLine();
                if (anchorLine < srcLine || srcSpan == 0 && anchorLine == srcLine) {
                    this.drift(anchor);
                    anchorIterator.remove();
                    continue;
                }
                if (srcSpan <= 0 || anchorLine >= endLine) continue;
                this.result.orphan(anchor, new InternalPullRequestDiffCommentAnchor[0]);
                anchorIterator.remove();
            }
            this.workingDrift += dstSpan - srcSpan;
        }

        private void drift(InternalPullRequestDiffCommentAnchor anchor) {
            this.result.drift(this.workingDrift, anchor, new InternalPullRequestDiffCommentAnchor[0]);
        }
    }
}

